/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.LongIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.auth.Group;
import org.dcache.auth.UserAuthRecord;

@Entity
@Table(name="authgrouplist")
public class GroupList
implements Serializable,
Detachable,
PersistenceCapable {
    private static final long serialVersionUID = 6742997958634986522L;
    private long id;
    private String attribute;
    private List<Group> groups;
    private AuthorizationRecord authRecord;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="authsequence")
    @Column(name="id")
    public long getId() {
        GroupList objPC;
        return objPC.jdoGetid();
    }

    public long jdoGetid() {
        return this.id;
    }

    public void setId(long val) {
        GroupList objPC;
        if (objPC.jdoStateManager == null) {
            objPC.jdoSetid(val);
        } else {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 3, objPC.jdoGetid(), val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(3);
        }
    }

    public void jdoSetid(long id) {
        this.id = id;
    }

    @Basic
    public String getAttribute() {
        GroupList objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.jdoGetattribute());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"attribute\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetattribute();
    }

    public String jdoGetattribute() {
        return this.attribute;
    }

    public void setAttribute(String val) {
        GroupList objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.jdoGetattribute(), val);
        } else {
            objPC.jdoSetattribute(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    public void jdoSetattribute(String attribute) {
        this.attribute = attribute;
    }

    @OneToMany(mappedBy="groupList", fetch=FetchType.EAGER, targetEntity=Group.class, cascade={CascadeType.ALL})
    @OrderBy
    public List<Group> getGroups() {
        GroupList objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.jdoGetgroups());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"groups\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetgroups();
    }

    public List jdoGetgroups() {
        return this.groups;
    }

    public void setGroups(List<Group> val) {
        GroupList objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.jdoGetgroups(), val);
        } else {
            objPC.jdoSetgroups(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    public void jdoSetgroups(List groups) {
        this.groups = groups;
    }

    @ManyToOne(targetEntity=AuthorizationRecord.class, fetch=FetchType.EAGER)
    @JoinColumn(name="authrecord_id")
    public AuthorizationRecord getAuthRecord() {
        GroupList objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (AuthorizationRecord)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.jdoGetauthRecord());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"authRecord\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetauthRecord();
    }

    public AuthorizationRecord jdoGetauthRecord() {
        return this.authRecord;
    }

    public void setAuthRecord(AuthorizationRecord val) {
        GroupList objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.jdoGetauthRecord(), (Object)val);
        } else {
            objPC.jdoSetauthRecord(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    public void jdoSetauthRecord(AuthorizationRecord authRecord) {
        this.authRecord = authRecord;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public void toStringBuilder(StringBuilder sb) {
        sb.append("GL:");
        sb.append(this.attribute).append(' ');
        if (this.groups != null) {
            sb.append(this.groups.size()).append(" groups : [");
            for (Group group : this.groups) {
                group.toStringBuilder(sb);
                sb.append(',');
            }
            sb.append(']');
        } else {
            sb.append(" [empty]");
        }
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attribute).append(' ');
        if (this.groups != null) {
            sb.append('[');
            for (Group group : this.groups) {
                sb.append(group.getGid()).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(']');
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public String hashCodeString() {
        return Integer.toHexString(this.hashCode());
    }

    @Transient
    public Group getPrimaryGroup() {
        if (this.groups != null && !this.groups.isEmpty()) {
            return this.groups.get(0);
        }
        return null;
    }

    public boolean equals(Object glist) {
        if (this == glist) {
            return true;
        }
        if (!(glist instanceof GroupList)) {
            return false;
        }
        GroupList gl = (GroupList)glist;
        if (this.attribute == null ? gl.getAttribute() != null : !this.attribute.equals(gl.getAttribute())) {
            return false;
        }
        return !(this.groups == null ? gl.getGroups() != null : !this.groups.equals(gl.getGroups()));
    }

    public int hashCode() {
        return this.toShortString().hashCode();
    }

    @Transient
    public UserAuthRecord getUserAuthRecord() {
        int i = 0;
        int glsize = this.groups.size();
        int[] GIDS = glsize > 0 ? new int[glsize] : null;
        for (Group group : this.groups) {
            GIDS[i++] = group.getGid();
        }
        return new UserAuthRecord(this.authRecord.getIdentity(), this.authRecord.getName(), this.attribute, this.authRecord.isReadOnly(), this.authRecord.getPriority(), this.authRecord.getUid(), GIDS, this.authRecord.getHome(), this.authRecord.getRoot(), "/", new HashSet());
    }

    static {
        jdoFieldNames = GroupList.__jdoFieldNamesInit();
        jdoFieldTypes = GroupList.__jdoFieldTypesInit();
        jdoFieldFlags = GroupList.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = GroupList.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = GroupList.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)GroupList.___jdo$loadClass("org.dcache.auth.GroupList"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new GroupList());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.LongIdentity");
        }
        LongIdentity o = (LongIdentity)oid;
        fc.storeLongField(3, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.LongIdentity or null");
        }
        LongIdentity o = (LongIdentity)oid;
        this.jdoSetid(o.getKey());
    }

    public void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object jdoNewObjectIdInstance() {
        return new LongIdentity(this.getClass(), this.jdoGetid());
    }

    public Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongIdentity(this.getClass(), (Long)key);
        }
        return new LongIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        GroupList result = new GroupList();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        GroupList result = new GroupList();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoSetattribute(this.jdoStateManager.replacingStringField((PersistenceCapable)this, index));
                break;
            }
            case 1: {
                this.jdoSetauthRecord((AuthorizationRecord)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index));
                break;
            }
            case 2: {
                this.jdoSetgroups((List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index));
                break;
            }
            case 3: {
                this.jdoSetid(this.jdoStateManager.replacingLongField((PersistenceCapable)this, index));
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.jdoGetattribute());
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.jdoGetauthRecord());
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.jdoGetgroups());
                break;
            }
            case 3: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this.jdoGetid());
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(GroupList obj, int index) {
        switch (index) {
            case 0: {
                this.jdoSetattribute(obj.jdoGetattribute());
                break;
            }
            case 1: {
                this.jdoSetauthRecord(obj.jdoGetauthRecord());
                break;
            }
            case 2: {
                this.jdoSetgroups(obj.jdoGetgroups());
                break;
            }
            case 3: {
                this.jdoSetid(obj.jdoGetid());
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof GroupList)) {
            throw new IllegalArgumentException("object is not an object of type org.dcache.auth.GroupList");
        }
        GroupList other = (GroupList)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"attribute", "authRecord", "groups", "id"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{GroupList.___jdo$loadClass("java.lang.String"), GroupList.___jdo$loadClass("org.dcache.auth.AuthorizationRecord"), GroupList.___jdo$loadClass("java.util.List"), Long.TYPE};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 5, 24};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 4;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        GroupList o = (GroupList)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }
}

