/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import diskCacheV111.util.CacheException;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;

public class CachingLoginStrategy
implements LoginStrategy {
    private final LoginStrategy _loginStrategy;
    private LoginReply _lastReply;
    private Subject _lastSubject;

    public CachingLoginStrategy(LoginStrategy loginStrategy) {
        this._loginStrategy = loginStrategy;
    }

    @Override
    public synchronized LoginReply login(Subject subject) throws CacheException {
        if (!subject.equals(this._lastSubject)) {
            this._lastReply = this._loginStrategy.login(subject);
            this._lastSubject = new Subject(true, subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
        }
        return this._lastReply;
    }

    @Override
    public Principal map(Principal principal) throws CacheException {
        return null;
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        return Collections.emptySet();
    }
}

