/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.LongIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.security.auth.Subject;
import org.dcache.auth.FQAN;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.Group;
import org.dcache.auth.GroupList;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.LoginReply;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserAuthRecord;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.srm.SRMUser;
import org.globus.gsi.jaas.GlobusPrincipal;

@Entity
@Table(name="authrecord")
public class AuthorizationRecord
implements Serializable,
SRMUser,
Detachable,
PersistenceCapable {
    private static final long serialVersionUID = 7412538400840464074L;
    private static final String PRIMARY_ATTRIBUTE_PREFIX_THAT_RETURN_IDENTITY_AS_VO_GROUP = "/Role=";
    private long id;
    private String identity;
    private String name;
    private int uid;
    private List<GroupList> groupLists;
    private int priority;
    private String home = "/";
    private String root = "/";
    private boolean readOnly;
    private int currentGIDindex;
    private String authn;
    private String authz;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public AuthorizationRecord() {
    }

    public AuthorizationRecord(Subject subject) {
        this(new LoginReply(subject, Collections.emptySet()));
    }

    public AuthorizationRecord(LoginReply login) {
        boolean hasUid = false;
        LinkedList<GroupList> groupLists = new LinkedList<GroupList>();
        GroupList primaryGroupList = new GroupList();
        primaryGroupList.setAuthRecord(this);
        primaryGroupList.setGroups(new ArrayList<Group>());
        groupLists.add(primaryGroupList);
        this.setIdentity("");
        for (Principal principal : login.getSubject().getPrincipals()) {
            if (principal instanceof UidPrincipal) {
                if (hasUid) {
                    throw new IllegalArgumentException("Cannot convert Subject with more than one UID");
                }
                hasUid = true;
                this.setUid((int)((UidPrincipal)principal).getUid());
                continue;
            }
            if (principal instanceof FQANPrincipal) {
                FQANPrincipal fqanPrincipal = (FQANPrincipal)principal;
                if (fqanPrincipal.isPrimaryGroup() && primaryGroupList.getAttribute() == null) {
                    primaryGroupList.setAttribute(fqanPrincipal.getName());
                    continue;
                }
                GroupList groupList = new GroupList();
                groupList.setAuthRecord(this);
                groupList.setAttribute(fqanPrincipal.getName());
                groupList.setGroups(new ArrayList<Group>());
                groupLists.add(groupList);
                continue;
            }
            if (principal instanceof GidPrincipal) {
                GidPrincipal gidPrincipal = (GidPrincipal)principal;
                Group group = new Group();
                group.setGroupList(primaryGroupList);
                group.setGid((int)gidPrincipal.getGid());
                if (gidPrincipal.isPrimaryGroup()) {
                    primaryGroupList.getGroups().add(0, group);
                    continue;
                }
                primaryGroupList.getGroups().add(group);
                continue;
            }
            if (principal instanceof GlobusPrincipal) {
                this.setName(principal.getName());
                continue;
            }
            if (principal instanceof UserNamePrincipal) {
                this.identity = principal.getName();
                continue;
            }
            if (!(principal instanceof GroupNamePrincipal)) continue;
            GroupNamePrincipal group = (GroupNamePrincipal)principal;
            if (this.identity == null || !group.isPrimaryGroup()) continue;
            this.identity = principal.getName();
        }
        if (!hasUid) {
            throw new IllegalArgumentException("Cannot convert Subject without UID");
        }
        this.setGroupLists(groupLists);
        for (LoginAttribute attribute : login.getLoginAttributes()) {
            if (attribute instanceof RootDirectory) {
                this.setRoot(((RootDirectory)attribute).getRoot());
                continue;
            }
            if (attribute instanceof HomeDirectory) {
                this.setHome(((HomeDirectory)attribute).getHome());
                continue;
            }
            if (!(attribute instanceof ReadOnly)) continue;
            this.setReadOnly(((ReadOnly)attribute).isReadOnly());
        }
        this.resetId();
    }

    public Subject toSubject() {
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add((Principal)new UidPrincipal((long)this.getUid()));
        String identity = this.getIdentity();
        if (identity != null && !identity.isEmpty()) {
            principals.add((Principal)new UserNamePrincipal(identity));
        }
        boolean primary = true;
        for (GroupList list : this.getGroupLists()) {
            String fqan = list.getAttribute();
            if (fqan != null && !fqan.isEmpty()) {
                principals.add((Principal)new FQANPrincipal(fqan, primary));
            }
            for (Group group : list.getGroups()) {
                principals.add((Principal)new GidPrincipal((long)group.getGid(), primary));
                primary = false;
            }
            primary = false;
        }
        String dn = this.getName();
        if (dn != null && !dn.isEmpty()) {
            principals.add((Principal)new GlobusPrincipal(dn));
        }
        return subject;
    }

    @Id
    @Column(name="id")
    public long getId() {
        AuthorizationRecord objPC;
        return objPC.jdoGetid();
    }

    public long jdoGetid() {
        return this.id;
    }

    public void setId(long val) {
        AuthorizationRecord objPC;
        if (objPC.jdoStateManager == null) {
            objPC.jdoSetid(val);
        } else {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 2, objPC.jdoGetid(), val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(2);
        }
    }

    public void jdoSetid(long id) {
        this.id = id;
    }

    public void resetId() {
        if (this.id != 0L) {
            return;
        }
        this.id = this.computeId(this);
    }

    @Basic
    @Column(name="identity")
    public String getIdentity() {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.jdoGetidentity());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"identity\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetidentity();
    }

    public String jdoGetidentity() {
        return this.identity;
    }

    public void setIdentity(String val) {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.jdoGetidentity(), val);
        } else {
            objPC.jdoSetidentity(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    public void jdoSetidentity(String identity) {
        this.identity = identity;
    }

    @Basic
    @Column(name="uid")
    public int getUid() {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 8, objPC.jdoGetuid());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"uid\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetuid();
    }

    public int jdoGetuid() {
        return this.uid;
    }

    public void setUid(int val) {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 8, objPC.jdoGetuid(), val);
        } else {
            objPC.jdoSetuid(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    public void jdoSetuid(int uid) {
        this.uid = uid;
    }

    @OneToMany(mappedBy="authRecord", fetch=FetchType.EAGER, targetEntity=GroupList.class, cascade={CascadeType.ALL})
    @OrderBy
    public List<GroupList> getGroupLists() {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.jdoGetgroupLists());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"groupLists\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetgroupLists();
    }

    public List jdoGetgroupLists() {
        return this.groupLists;
    }

    public void setGroupLists(List<GroupList> val) {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.jdoGetgroupLists(), val);
        } else {
            objPC.jdoSetgroupLists(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    public void jdoSetgroupLists(List groupLists) {
        this.groupLists = groupLists;
    }

    @Basic
    @Column(name="priority")
    public int getPriority() {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 5, objPC.jdoGetpriority());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"priority\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetpriority();
    }

    public int jdoGetpriority() {
        return this.priority;
    }

    public void setPriority(int val) {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 5, objPC.jdoGetpriority(), val);
        } else {
            objPC.jdoSetpriority(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    public void jdoSetpriority(int priority) {
        this.priority = priority;
    }

    @Basic
    @Column(name="home")
    public String getHome() {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.jdoGethome());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"home\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGethome();
    }

    public String jdoGethome() {
        return this.home;
    }

    public void setHome(String val) {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.jdoGethome(), val);
        } else {
            objPC.jdoSethome(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    public void jdoSethome(String Home) {
        Preconditions.checkNotNull((Object)Home);
        this.home = Home;
    }

    @Basic
    @Column(name="root")
    public String getRoot() {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.jdoGetroot());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"root\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetroot();
    }

    public String jdoGetroot() {
        return this.root;
    }

    public void setRoot(String val) {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.jdoGetroot(), val);
        } else {
            objPC.jdoSetroot(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    public void jdoSetroot(String Root) {
        Preconditions.checkNotNull((Object)Root);
        this.root = Root;
    }

    @Basic
    @Column(name="read_only")
    public boolean isReadOnly() {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getBooleanField((PersistenceCapable)objPC, 6, objPC.jdoGetreadOnly());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"readOnly\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetreadOnly();
    }

    public boolean jdoGetreadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean val) {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setBooleanField((PersistenceCapable)objPC, 6, objPC.jdoGetreadOnly(), val);
        } else {
            objPC.jdoSetreadOnly(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    public void jdoSetreadOnly(boolean ReadOnly2) {
        this.readOnly = ReadOnly2;
    }

    @Transient
    public String getAuthn() {
        if (this.authn == null) {
            this.initHashStrings();
        }
        return this.authn;
    }

    @Transient
    public String getAuthz() {
        if (this.authz == null) {
            this.initHashStrings();
        }
        return this.authz;
    }

    @Transient
    public int getCurrentGIDindex() {
        return this.currentGIDindex;
    }

    public void setCurrentGIDindex(int currentGIDindex) {
        this.currentGIDindex = currentGIDindex;
    }

    public void incrementGIDindex() {
        ++this.currentGIDindex;
    }

    @Basic
    @Column(name="name")
    public String getName() {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.jdoGetname());
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access property \"name\" yet this property was not detached when you detached the object. Either dont access this property, or detach it when detaching the object.");
        }
        return objPC.jdoGetname();
    }

    public String jdoGetname() {
        return this.name;
    }

    public void setName(String val) {
        AuthorizationRecord objPC;
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.jdoGetname(), val);
        } else {
            objPC.jdoSetname(val);
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    public void jdoSetname(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AR:");
        sb.append(this.getId());
        sb.append(' ').append(this.identity);
        sb.append(' ').append(this.name);
        sb.append(' ').append(this.uid);
        if (this.readOnly) {
            sb.append(" read-only ");
        } else {
            sb.append(" read-write ");
        }
        sb.append(this.priority).append(' ');
        sb.append(this.home).append(' ');
        sb.append(this.root).append(" < ");
        if (this.groupLists != null) {
            sb.append(this.groupLists.size()).append(" groupLists : ");
            for (GroupList groupList : this.groupLists) {
                sb.append("  ").append(groupList).append(';');
            }
        } else {
            sb.append("empty");
        }
        sb.append(" >");
        return sb.toString();
    }

    public String hashCodeString() {
        return Integer.toHexString(this.hashCode());
    }

    @Transient
    public String getVoRole() {
        FQAN fqan;
        String primaryAttribute = this.getPrimaryAttribute();
        if (FQAN.isValid((String)primaryAttribute) && (fqan = new FQAN(primaryAttribute)).hasRole()) {
            return fqan.getRole();
        }
        return null;
    }

    @Transient
    public String getVoGroup() {
        String primaryAttribute = this.getPrimaryAttribute();
        if (primaryAttribute != null && !primaryAttribute.isEmpty()) {
            if (FQAN.isValid((String)primaryAttribute)) {
                return new FQAN(primaryAttribute).getGroup();
            }
            if (!primaryAttribute.startsWith(PRIMARY_ATTRIBUTE_PREFIX_THAT_RETURN_IDENTITY_AS_VO_GROUP)) {
                return primaryAttribute;
            }
        }
        return this.identity;
    }

    @Transient
    protected String getPrimaryAttribute() {
        GroupList primaryGroupList = this.getPrimaryGroupList();
        if (primaryGroupList != null) {
            return primaryGroupList.getAttribute();
        }
        return null;
    }

    @Transient
    protected GroupList getPrimaryGroupList() {
        if (this.groupLists != null && !this.groupLists.isEmpty()) {
            return this.groupLists.get(0);
        }
        return null;
    }

    @Transient
    public int getGid() {
        Group primaryGroup;
        GroupList primaryGroupList = this.getPrimaryGroupList();
        if (primaryGroupList != null && (primaryGroup = primaryGroupList.getPrimaryGroup()) != null) {
            return primaryGroup.getGid();
        }
        return -1;
    }

    @Transient
    public long computeId(AuthorizationRecord authrec) {
        long id = authrec.getId();
        if (id != 0L) {
            return id;
        }
        int authn_hash = this.getAuthn().hashCode();
        int authz_hash = this.getAuthz().hashCode();
        id = (long)authn_hash << 32 | (long)authz_hash & 0xFFFFFFFFL;
        return id;
    }

    private void initHashStrings() {
        if (this.authn != null && this.authz != null) {
            return;
        }
        StringBuilder authn = new StringBuilder();
        StringBuilder authz = new StringBuilder();
        authn.append(this.name);
        authz.append(this.uid);
        if (this.groupLists != null) {
            authn.append(',');
            authz.append(' ');
            for (GroupList groupList : this.groupLists) {
                if (groupList != null) {
                    authn.append(groupList.getAttribute()).append('|');
                    authz.append(groupList.toShortString()).append('|');
                    continue;
                }
                authn.append("null|");
                authz.append("null|");
            }
            authn.deleteCharAt(authn.length() - 1);
            authz.deleteCharAt(authz.length() - 1);
        }
        if (this.readOnly) {
            authz.append(" read-only");
        } else {
            authz.append(" read-write");
        }
        authz.append(' ').append(this.priority);
        authz.append(' ').append(this.home);
        authz.append(' ').append(this.root);
        this.authn = authn.toString();
        this.authz = authz.toString();
    }

    public boolean equals(Object rec) {
        if (this == rec) {
            return true;
        }
        if (!(rec instanceof AuthorizationRecord)) {
            return false;
        }
        AuthorizationRecord r = (AuthorizationRecord)rec;
        return Objects.equal((Object)this.identity, (Object)r.identity) && Objects.equal((Object)this.name, (Object)r.name) && this.uid == r.getUid() && this.readOnly == r.isReadOnly() && Objects.equal(this.groupLists, r.groupLists) && this.priority == r.getPriority() && Objects.equal((Object)this.home, (Object)r.home) && Objects.equal((Object)this.root, (Object)r.root);
    }

    public int hashCode() {
        this.initHashStrings();
        return this.getAuthn().hashCode() ^ this.getAuthz().hashCode();
    }

    @Transient
    public int[] getGids() {
        ArrayList<Integer> gids = new ArrayList<Integer>();
        if (this.groupLists != null) {
            for (GroupList groupList : this.groupLists) {
                List<Group> groups = groupList.getGroups();
                if (groups == null) continue;
                for (Group group : groups) {
                    gids.add(group.getGid());
                }
            }
        }
        if (gids.isEmpty()) {
            return new int[]{-1};
        }
        int[] gidIntArray = new int[gids.size()];
        for (int i = 0; i < gidIntArray.length; ++i) {
            gidIntArray[i] = (Integer)gids.get(i);
        }
        return gidIntArray;
    }

    @Transient
    public UserAuthRecord getUserAuthRecord() {
        return new UserAuthRecord(this.getIdentity(), this.getName(), this.getPrimaryAttribute(), this.isReadOnly(), this.getPriority(), this.getUid(), this.getGids(), this.getHome(), this.getRoot(), "/", new HashSet());
    }

    static {
        jdoFieldNames = AuthorizationRecord.__jdoFieldNamesInit();
        jdoFieldTypes = AuthorizationRecord.__jdoFieldTypesInit();
        jdoFieldFlags = AuthorizationRecord.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = AuthorizationRecord.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = AuthorizationRecord.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)AuthorizationRecord.___jdo$loadClass("org.dcache.auth.AuthorizationRecord"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new AuthorizationRecord());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.LongIdentity");
        }
        LongIdentity o = (LongIdentity)oid;
        fc.storeLongField(2, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.LongIdentity or null");
        }
        LongIdentity o = (LongIdentity)oid;
        this.jdoSetid(o.getKey());
    }

    public void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object jdoNewObjectIdInstance() {
        return new LongIdentity(this.getClass(), this.jdoGetid());
    }

    public Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongIdentity(this.getClass(), (Long)key);
        }
        return new LongIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        AuthorizationRecord result = new AuthorizationRecord();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        AuthorizationRecord result = new AuthorizationRecord();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoSetgroupLists((List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index));
                break;
            }
            case 1: {
                this.jdoSethome(this.jdoStateManager.replacingStringField((PersistenceCapable)this, index));
                break;
            }
            case 2: {
                this.jdoSetid(this.jdoStateManager.replacingLongField((PersistenceCapable)this, index));
                break;
            }
            case 3: {
                this.jdoSetidentity(this.jdoStateManager.replacingStringField((PersistenceCapable)this, index));
                break;
            }
            case 4: {
                this.jdoSetname(this.jdoStateManager.replacingStringField((PersistenceCapable)this, index));
                break;
            }
            case 5: {
                this.jdoSetpriority(this.jdoStateManager.replacingIntField((PersistenceCapable)this, index));
                break;
            }
            case 6: {
                this.jdoSetreadOnly(this.jdoStateManager.replacingBooleanField((PersistenceCapable)this, index));
                break;
            }
            case 7: {
                this.jdoSetroot(this.jdoStateManager.replacingStringField((PersistenceCapable)this, index));
                break;
            }
            case 8: {
                this.jdoSetuid(this.jdoStateManager.replacingIntField((PersistenceCapable)this, index));
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.jdoGetgroupLists());
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.jdoGethome());
                break;
            }
            case 2: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this.jdoGetid());
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.jdoGetidentity());
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.jdoGetname());
                break;
            }
            case 5: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, index, this.jdoGetpriority());
                break;
            }
            case 6: {
                this.jdoStateManager.providedBooleanField((PersistenceCapable)this, index, this.jdoGetreadOnly());
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.jdoGetroot());
                break;
            }
            case 8: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, index, this.jdoGetuid());
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(AuthorizationRecord obj, int index) {
        switch (index) {
            case 0: {
                this.jdoSetgroupLists(obj.jdoGetgroupLists());
                break;
            }
            case 1: {
                this.jdoSethome(obj.jdoGethome());
                break;
            }
            case 2: {
                this.jdoSetid(obj.jdoGetid());
                break;
            }
            case 3: {
                this.jdoSetidentity(obj.jdoGetidentity());
                break;
            }
            case 4: {
                this.jdoSetname(obj.jdoGetname());
                break;
            }
            case 5: {
                this.jdoSetpriority(obj.jdoGetpriority());
                break;
            }
            case 6: {
                this.jdoSetreadOnly(obj.jdoGetreadOnly());
                break;
            }
            case 7: {
                this.jdoSetroot(obj.jdoGetroot());
                break;
            }
            case 8: {
                this.jdoSetuid(obj.jdoGetuid());
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof AuthorizationRecord)) {
            throw new IllegalArgumentException("object is not an object of type org.dcache.auth.AuthorizationRecord");
        }
        AuthorizationRecord other = (AuthorizationRecord)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"groupLists", "home", "id", "identity", "name", "priority", "readOnly", "root", "uid"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{AuthorizationRecord.___jdo$loadClass("java.util.List"), AuthorizationRecord.___jdo$loadClass("java.lang.String"), Long.TYPE, AuthorizationRecord.___jdo$loadClass("java.lang.String"), AuthorizationRecord.___jdo$loadClass("java.lang.String"), Integer.TYPE, Boolean.TYPE, AuthorizationRecord.___jdo$loadClass("java.lang.String"), Integer.TYPE};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{5, 21, 24, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 9;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        AuthorizationRecord o = (AuthorizationRecord)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }
}

