/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import diskCacheV111.util.CacheException;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Subjects;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.attributes.LoginAttribute;
import org.springframework.beans.factory.annotation.Required;

public class AnonymousLoginStrategy
implements LoginStrategy {
    public static final String USER_ROOT = "root";
    public static final String USER_NOBODY = "nobody";
    public static final Pattern USER_PATTERN = Pattern.compile("(\\d+):((\\d+)(,(\\d+))*)");
    private static final Set<LoginAttribute> NO_ATTRIBUTES = Collections.emptySet();
    private Subject _subject;

    @Override
    public LoginReply login(Subject subject) throws CacheException {
        return new LoginReply(this._subject, NO_ATTRIBUTES);
    }

    @Override
    public Principal map(Principal principal) throws CacheException {
        return null;
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        return null;
    }

    private Subject parseUidGidList(String user) {
        Matcher matcher = USER_PATTERN.matcher(user);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid user string");
        }
        Subject subject = new Subject();
        int uid = Integer.parseInt(matcher.group(1));
        Set<Principal> principals = subject.getPrincipals();
        principals.add((Principal)new UidPrincipal((long)uid));
        boolean primary = true;
        for (String group : matcher.group(2).split(",")) {
            int gid = Integer.parseInt(group);
            principals.add((Principal)new GidPrincipal((long)gid, primary));
            primary = false;
        }
        subject.setReadOnly();
        return subject;
    }

    @Required
    public void setUser(String user) {
        switch (user) {
            case "root": {
                this._subject = Subjects.ROOT;
                break;
            }
            case "nobody": {
                this._subject = Subjects.NOBODY;
                break;
            }
            default: {
                this._subject = this.parseUidGidList(user);
            }
        }
    }
}

