/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import org.slf4j.LoggerFactory;

public class LogEntryServerWrapper {
    private String baseDir;
    private String configFile;
    private String definitionsPath;
    private String path;
    private String properties;
    private String driver;
    private String url;
    private String user;
    private String pass;
    private String level;
    private Integer port;
    private SimpleSocketServer server;

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setDefinitions(String definitionsPath) {
        this.definitionsPath = definitionsPath;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setServer(SimpleSocketServer server) {
        this.server = server;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void shutDown() {
        if (this.server != null) {
            this.server.close();
        }
    }

    public void startUp() throws JoranException {
        if (Strings.isNullOrEmpty((String)this.url)) {
            LoggerFactory.getLogger((String)"root").warn("alarms database type is OFF; server will not be started");
            return;
        }
        Preconditions.checkNotNull((Object)this.configFile);
        Preconditions.checkNotNull((Object)this.baseDir);
        File f = new File(this.baseDir);
        Preconditions.checkArgument((boolean)f.isDirectory());
        Preconditions.checkNotNull((Object)this.port);
        Preconditions.checkArgument((this.port > 0 ? 1 : 0) != 0);
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
        loggerContext.putProperty("alarms.dir", f.getAbsolutePath());
        loggerContext.putProperty("alarms.store.path", this.path);
        loggerContext.putProperty("alarms.store.db.driver", this.driver);
        loggerContext.putProperty("alarms.store.db.url", this.url);
        loggerContext.putProperty("alarms.store.db.user", this.user);
        loggerContext.putProperty("alarms.store.db.pass", this.pass);
        loggerContext.putProperty("alarms.store.db.properties", this.properties);
        loggerContext.putProperty("alarms.definitions.path", this.definitionsPath);
        loggerContext.putProperty("alarms.server.log.level", this.level);
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        configurator.doConfigure(this.configFile);
        this.server = new SimpleSocketServer(loggerContext, this.port.intValue());
        this.server.start();
    }
}

