/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

public class RemoteMDCFilter
extends Filter<ILoggingEvent> {
    private static String host;

    public static String getHost() {
        return host;
    }

    public FilterReply decide(ILoggingEvent event) {
        Map mdc = event.getMDCPropertyMap();
        mdc.put("host", host);
        mdc.put("service", mdc.get("cells.cell"));
        mdc.put("domain", mdc.get("cells.domain"));
        return FilterReply.NEUTRAL;
    }

    static {
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            host = "<unknown host>";
        }
    }
}

