/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.MDC;
import org.dcache.alarms.dao.ILogEntryDAO;
import org.dcache.alarms.dao.LogEntry;
import org.dcache.alarms.dao.impl.DataNucleusLogEntryStore;
import org.dcache.alarms.logback.AlarmDefinition;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LogEntryAppender
extends AppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private final Properties properties = new Properties();
    private final Map<String, AlarmDefinition> definitions = Collections.synchronizedMap(new TreeMap());
    private final Map<String, Appender<ILoggingEvent>> childAppenders = Collections.synchronizedMap(new HashMap());
    private ILogEntryDAO store;
    private String path;
    private String propertiesPath;
    private String definitionsPath;
    private String currentDomain;

    public void addAlarmType(AlarmDefinition definition) {
        this.definitions.put(definition.getType(), definition);
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        this.childAppenders.put(newAppender.getName(), newAppender);
    }

    public void detachAndStopAllAppenders() {
        Iterator<String> key = this.childAppenders.keySet().iterator();
        while (key.hasNext()) {
            Appender<ILoggingEvent> appender = this.childAppenders.get(key.next());
            appender.stop();
            key.remove();
        }
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        if (appender != null) {
            return this.detachAppender(appender.getName());
        }
        return false;
    }

    public boolean detachAppender(String name) {
        Appender<ILoggingEvent> a = this.childAppenders.remove(name);
        return a != null;
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.childAppenders.get(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.childAppenders.containsValue(appender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.childAppenders.values().iterator();
    }

    public void setDefinitionsPath(String definitionsPath) {
        this.definitionsPath = definitionsPath;
    }

    public void setDriver(String driver) {
        this.properties.setProperty("datanucleus.ConnectionDriverName", driver);
    }

    public void setPass(String pass) {
        this.properties.setProperty("datanucleus.ConnectionPassword", pass);
    }

    public void setPropertiesPath(String propertiesPath) {
        this.propertiesPath = propertiesPath;
    }

    public void setStorePath(String path) {
        this.path = path;
    }

    public void setUrl(String url) {
        this.properties.setProperty("datanucleus.ConnectionURL", url);
    }

    public void setUser(String user) {
        this.properties.setProperty("datanucleus.ConnectionUserName", user);
    }

    public void start() {
        try {
            File file;
            this.currentDomain = String.valueOf(MDC.get((String)"cells.domain"));
            if (this.definitionsPath != null && this.definitionsPath.trim().length() > 0) {
                file = new File(this.definitionsPath);
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                this.loadDefinitions(file);
            }
            if (this.store == null) {
                if (this.propertiesPath != null && this.propertiesPath.trim().length() > 0) {
                    file = new File(this.propertiesPath);
                    if (!file.exists()) {
                        throw new FileNotFoundException(file.getAbsolutePath());
                    }
                    try (FileInputStream stream = new FileInputStream(file);){
                        this.properties.load(stream);
                    }
                }
                this.store = new DataNucleusLogEntryStore(this.path, this.properties);
            }
            for (Appender<ILoggingEvent> child : this.childAppenders.values()) {
                child.start();
            }
            super.start();
        }
        catch (IOException | JDOMException t) {
            throw new RuntimeException(t);
        }
    }

    protected void append(ILoggingEvent eventObject) {
        if (this.isStarted()) {
            if (this.currentDomain.equals(eventObject.getMDCPropertyMap().get("domain"))) {
                Logger logger = (Logger)LoggerFactory.getLogger((String)"domain");
                if (logger != null && logger.isEnabledFor(eventObject.getLevel())) {
                    logger.callAppenders(eventObject);
                }
                return;
            }
            LogEntry entry = this.createEntryFromEvent(eventObject);
            String type = entry.getType();
            if (!(type == null || Level.ERROR.toString().equals(type) || Level.WARN.toString().equals(type) || Level.INFO.toString().equals(type) || Level.DEBUG.toString().equals(type) || Level.TRACE.toString().equals(type))) {
                eventObject = this.cloneAndMark(type, eventObject);
            }
            for (Appender<ILoggingEvent> delegate : this.childAppenders.values()) {
                delegate.doAppend((Object)eventObject);
            }
            this.store.put(entry);
        }
    }

    void setStore(ILogEntryDAO store) {
        this.store = store;
    }

    private ILoggingEvent cloneAndMark(String type, ILoggingEvent eventObject) {
        Marker marker = AlarmDefinition.getMarker(type);
        LoggingEvent alarm = new LoggingEvent();
        alarm.setArgumentArray(eventObject.getArgumentArray());
        alarm.setCallerData(eventObject.getCallerData());
        alarm.setLevel(eventObject.getLevel());
        alarm.setLoggerName(eventObject.getLoggerName());
        alarm.setLoggerContextRemoteView(eventObject.getLoggerContextVO());
        alarm.setMDCPropertyMap(eventObject.getMDCPropertyMap());
        alarm.setMarker(marker);
        alarm.setMessage(eventObject.getMessage());
        alarm.setThreadName(eventObject.getThreadName());
        alarm.setThrowableProxy((ThrowableProxy)eventObject.getThrowableProxy());
        alarm.setTimeStamp(eventObject.getTimeStamp());
        return alarm;
    }

    private LogEntry createEntryFromEvent(ILoggingEvent eventObject) {
        String service;
        String domain;
        LogEntry entry = new LogEntry();
        Long timestamp = eventObject.getTimeStamp();
        entry.setFirstArrived(timestamp);
        entry.setLastUpdate(timestamp);
        entry.setInfo(eventObject.getFormattedMessage());
        Map mdc = eventObject.getMDCPropertyMap();
        String host = (String)mdc.get("host");
        if (host == null) {
            host = "<unknown host>";
        }
        if ((domain = (String)mdc.get("domain")) == null) {
            domain = "<unknown domain>";
        }
        if ((service = (String)mdc.get("service")) == null) {
            service = "<unknown service>";
        }
        entry.setHost(host);
        entry.setDomain(domain);
        entry.setService(service);
        this.postProcessAlarm(eventObject, entry);
        return entry;
    }

    private void loadDefinitions(File xmlFile) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(xmlFile);
        Element rootNode = document.getRootElement();
        List list = rootNode.getChildren("alarmType");
        for (Element node : list) {
            this.addAlarmType(new AlarmDefinition(node));
        }
    }

    private void postProcessAlarm(ILoggingEvent event, LogEntry entry) {
        Marker marker = event.getMarker();
        boolean alarm = marker == null ? false : marker.contains("ALARM");
        AlarmDefinition match = null;
        for (AlarmDefinition definition : this.definitions.values()) {
            if (!definition.matches(event)) continue;
            alarm = true;
            match = definition;
            break;
        }
        entry.setAlarm(alarm);
        entry.setAlarmMetadata(event, match);
    }
}

