/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dcache.alarms.AlarmDefinitionValidationException;
import org.dcache.alarms.Severity;
import org.dcache.util.RegexUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AlarmDefinition {
    public static final String ALARM_TYPE_TAG = "alarmType";
    public static final String DEPTH_TAG = "depth";
    public static final String INCLUDE_IN_KEY_TAG = "includeInKey";
    public static final String LEVEL_TAG = "level";
    public static final String LOGGER_TAG = "logger";
    public static final String MATCH_EXCEPTION_TAG = "matchException";
    public static final String REGEX_TAG = "regex";
    public static final String REGEX_FLAGS_TAG = "regexFlags";
    public static final String THREAD_TAG = "thread";
    public static final String INCLUDE_IN_KEY_DELIMITER = "[\\s]";
    public static final String RM = "-";
    public static final ImmutableList<String> ATTRIBUTES = new ImmutableList.Builder().add((Object)"depth").add((Object)"includeInKey").add((Object)"level").add((Object)"logger").add((Object)"matchException").add((Object)"regex").add((Object)"regexFlags").add((Object)"severity").add((Object)"thread").add((Object)"type").build();
    private static final String REQUIRED = " is a required attribute";
    private static final ImmutableSet<String> KEY_VALUES = new ImmutableSet.Builder().add((Object)"timestamp").add((Object)"message").add((Object)"groupN").add((Object)"logger").add((Object)"type").add((Object)"domain").add((Object)"service").add((Object)"host").add((Object)"thread").build();
    private static final ImmutableSet<String> LEVEL_VALUES = new ImmutableSet.Builder().add((Object)Level.ERROR.toString()).add((Object)Level.WARN.toString()).add((Object)Level.INFO.toString()).add((Object)Level.DEBUG.toString()).add((Object)Level.TRACE.toString()).build();
    private static final ImmutableList<String> DEFINITIONS = new ImmutableList.Builder().add((Object)"match nested exception messages using regex only to this level (integer, optional; default: undefined)").add((Object)("create the unique identifier for this alarm event based on the selected fields (whitespace delimited) " + KEY_VALUES + " (required)")).add((Object)("match events at this logging level or greater " + LEVEL_VALUES + " (required)")).add((Object)"match events only generated by the named logger [usually a fully qualified Java class name] (required if regex not specified)").add((Object)"apply the regex to nested exception messages  (boolean, optional; default: false)").add((Object)"Java-style regular expression used to match messages  (required if logger is not specified)").add((Object)("Java-style flag options for regex; join using '|' (or) " + RegexUtils.FLAG_VALUES + " (optional; default: none)")).add((Object)("alarm-specific level " + Severity.asList() + " (optional; default: MODERATE)]")).add((Object)"match events emanating only from this JVM thread [JVM thread name] (optional; default: none)").add((Object)"choose a name to call this type of alarm (required)").build();
    private final Set<String> hashedKeyElements = Sets.newHashSet();
    private Level level = Level.WARN;
    private Severity severity = Severity.MODERATE;
    private Boolean matchException = false;
    private String type;
    private String logger;
    private String thread;
    private String regexStr;
    private String regexFlags;
    private Integer depth;
    private Pattern regex;

    public static String getAttributeDescription(String attribute) throws AlarmDefinitionValidationException {
        if (!ATTRIBUTES.contains((Object)attribute)) {
            throw new AlarmDefinitionValidationException("unrecognized attribute: " + attribute);
        }
        return (String)DEFINITIONS.get(ATTRIBUTES.indexOf((Object)attribute));
    }

    public static String getAttributesDescription() {
        StringBuilder builder = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        builder.append("ALARM DEFINITION ATTRIBUTES").append(newLine);
        for (int i = 0; i < ATTRIBUTES.size(); ++i) {
            builder.append("   (").append(i).append(") ").append((String)ATTRIBUTES.get(i)).append(":").append(newLine).append("       -- ").append((String)DEFINITIONS.get(i)).append(newLine);
        }
        return builder.toString();
    }

    public static Marker getMarker(String subMarker) {
        Marker alarmMarker = MarkerFactory.getIMarkerFactory().getMarker("ALARM");
        if (subMarker != null) {
            alarmMarker.add(MarkerFactory.getIMarkerFactory().getDetachedMarker(subMarker));
        }
        return alarmMarker;
    }

    public AlarmDefinition() {
    }

    public AlarmDefinition(Element alarmType) {
        Element child = alarmType.getChild(DEPTH_TAG);
        if (child != null) {
            this.setDepth(Integer.parseInt(child.getTextTrim()));
        }
        if ((child = alarmType.getChild(INCLUDE_IN_KEY_TAG)) != null) {
            this.setIncludeInKey(child.getTextTrim());
        }
        if ((child = alarmType.getChild(LEVEL_TAG)) != null) {
            this.setLevel(child.getTextTrim());
        }
        if ((child = alarmType.getChild(LOGGER_TAG)) != null) {
            this.setLevel(child.getTextTrim());
        }
        if ((child = alarmType.getChild(MATCH_EXCEPTION_TAG)) != null) {
            this.setMatchException(Boolean.valueOf(child.getTextTrim()));
        }
        if ((child = alarmType.getChild(REGEX_TAG)) != null) {
            this.setRegex(child.getTextTrim());
        }
        if ((child = alarmType.getChild(REGEX_FLAGS_TAG)) != null) {
            this.setRegexFlags(child.getTextTrim());
        }
        if ((child = alarmType.getChild("severity")) != null) {
            this.setSeverity(child.getTextTrim());
        }
        if ((child = alarmType.getChild(THREAD_TAG)) != null) {
            this.setThread(child.getTextTrim());
        }
        if ((child = alarmType.getChild("type")) != null) {
            this.setType(child.getTextTrim());
        }
    }

    public Integer getDepth() {
        return this.depth;
    }

    public String getIncludeInKey() {
        StringBuilder result = new StringBuilder();
        Joiner.on((String)" ").appendTo(result, this.hashedKeyElements.iterator());
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public String getKey(ILoggingEvent event, String host, String domain, String service) {
        StringBuilder key = new StringBuilder();
        for (String s : this.hashedKeyElements) {
            Matcher m;
            if (s.startsWith("group") && this.regex != null && (m = this.regex.matcher(event.getFormattedMessage())).find()) {
                int group = Integer.parseInt(s.substring("group".length()));
                key.append(m.group(group));
                continue;
            }
            switch (s) {
                case "timestamp": {
                    key.append(event.getTimeStamp());
                    break;
                }
                case "message": {
                    key.append(event.getFormattedMessage());
                    break;
                }
                case "type": {
                    key.append(this.type);
                    break;
                }
                case "host": {
                    key.append(host);
                    break;
                }
                case "domain": {
                    key.append(domain);
                    break;
                }
                case "service": {
                    key.append(service);
                    break;
                }
                case "logger": {
                    key.append(event.getLoggerName());
                    break;
                }
                case "thread": {
                    key.append(event.getThreadName());
                }
            }
        }
        return key.toString();
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLogger() {
        return this.logger;
    }

    public Boolean getMatchException() {
        return this.matchException;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public String getRegexFlags() {
        return this.regexFlags;
    }

    public String getRegexStr() {
        return this.regexStr;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Severity getSeverityEnum() {
        return this.severity;
    }

    public String getThread() {
        return this.thread;
    }

    public String getType() {
        return this.type;
    }

    public boolean matches(ILoggingEvent event) {
        if (!event.getLevel().isGreaterOrEqual(this.level)) {
            return false;
        }
        if (this.logger != null && !event.getLoggerName().equals(this.logger)) {
            return false;
        }
        if (this.thread != null && !event.getThreadName().equals(this.thread)) {
            return false;
        }
        if (this.regex == null && this.regexStr != null) {
            this.regex = Pattern.compile(this.regexStr, RegexUtils.parseFlags((String)this.regexFlags));
        }
        return this.regex == null || this.doMatch(event);
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public void setIncludeInKey(String includeInKey) {
        Preconditions.checkNotNull((Object)includeInKey);
        String[] keyNames = includeInKey.split(INCLUDE_IN_KEY_DELIMITER);
        this.hashedKeyElements.clear();
        Collections.addAll(this.hashedKeyElements, keyNames);
    }

    public void setLevel(String level) {
        Preconditions.checkNotNull((Object)level);
        this.level = Level.valueOf((String)level);
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public void setMatchException(Boolean matchException) {
        this.matchException = matchException;
    }

    public void setRegex(String regexStr) {
        this.regexStr = regexStr;
    }

    public void setRegexFlags(String regexFlags) {
        this.regexFlags = regexFlags;
    }

    public void setSeverity(String severity) {
        Preconditions.checkNotNull((Object)severity);
        this.severity = Severity.valueOf(severity);
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Element toElement() {
        String key;
        Element alarmType = new Element(ALARM_TYPE_TAG);
        if (this.depth != null) {
            alarmType.addContent((Content)new Element(DEPTH_TAG).setText(String.valueOf(this.depth)));
        }
        if ((key = this.getIncludeInKey()) != null && !key.isEmpty()) {
            alarmType.addContent((Content)new Element(INCLUDE_IN_KEY_TAG).setText(key));
        }
        if (this.level != null) {
            alarmType.addContent((Content)new Element(LEVEL_TAG).setText(this.level.toString()));
        }
        if (this.logger != null && !this.logger.isEmpty()) {
            alarmType.addContent((Content)new Element(LOGGER_TAG).setText(this.logger));
        }
        if (this.matchException != null && this.matchException.booleanValue()) {
            alarmType.addContent((Content)new Element(MATCH_EXCEPTION_TAG).setText(this.matchException.toString()));
        }
        if (this.regexStr != null && !this.regexStr.isEmpty()) {
            alarmType.addContent((Content)new Element(REGEX_TAG).setText(this.regexStr));
        }
        if (this.regexFlags != null && !this.regexFlags.isEmpty()) {
            alarmType.addContent((Content)new Element(REGEX_FLAGS_TAG).setText(this.regexFlags));
        }
        if (this.severity != null) {
            alarmType.addContent((Content)new Element("severity").setText(this.severity.toString()));
        }
        if (this.thread != null && !this.thread.isEmpty()) {
            alarmType.addContent((Content)new Element(THREAD_TAG).setText(this.thread));
        }
        if (this.type != null && !this.type.isEmpty()) {
            alarmType.addContent((Content)new Element("type").setText(this.type));
        }
        return alarmType;
    }

    public void validate() throws AlarmDefinitionValidationException {
        if (this.type == null) {
            throw new AlarmDefinitionValidationException("type is a required attribute");
        }
        if (this.level == null) {
            throw new AlarmDefinitionValidationException("level is a required attribute");
        }
        if (this.hashedKeyElements.isEmpty()) {
            throw new AlarmDefinitionValidationException("includeInKey is a required attribute");
        }
        if (this.logger == null && this.regexStr == null) {
            throw new AlarmDefinitionValidationException("either logger or regex is a required attribute");
        }
    }

    public void validateAndSet(String name, String value) throws AlarmDefinitionValidationException {
        if ((value = value.trim()).length() == 0 || RM.equals(value)) {
            value = null;
        }
        switch (name) {
            case "depth": {
                try {
                    if (value == null) {
                        this.depth = null;
                        break;
                    }
                    this.depth = Integer.parseInt(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new AlarmDefinitionValidationException(value + " is not an integer");
                }
            }
            case "includeInKey": {
                String[] parts;
                if (value == null) {
                    this.hashedKeyElements.clear();
                    return;
                }
                for (String part : parts = value.split(INCLUDE_IN_KEY_DELIMITER)) {
                    if (part.startsWith("group")) {
                        try {
                            Integer.parseInt(part.substring(5));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new AlarmDefinitionValidationException("group must end in an integer");
                        }
                    }
                    if (KEY_VALUES.contains((Object)part.trim())) continue;
                    throw new AlarmDefinitionValidationException(part + " is not a valid key field");
                }
                this.setIncludeInKey(value);
                break;
            }
            case "level": {
                if (value == null) {
                    this.level = null;
                    return;
                }
                if (!LEVEL_VALUES.contains((Object)value)) {
                    throw new AlarmDefinitionValidationException(value + " is not a valid level");
                }
                this.setLevel(value);
                break;
            }
            case "matchException": {
                if (value == null) {
                    this.matchException = null;
                    return;
                }
                try {
                    this.matchException = Boolean.parseBoolean(value);
                    break;
                }
                catch (Exception e) {
                    throw new AlarmDefinitionValidationException(value + " is not a boolean");
                }
            }
            case "regex": {
                if (value == null) {
                    this.regexStr = null;
                    return;
                }
                try {
                    Pattern.compile(value);
                }
                catch (PatternSyntaxException e) {
                    throw new AlarmDefinitionValidationException(value + " is not a valid regular expression");
                }
                this.regexStr = value;
                break;
            }
            case "regexFlags": {
                String[] parts;
                if (value == null) {
                    this.regexFlags = null;
                    return;
                }
                for (String part : parts = value.split("[|]")) {
                    if (RegexUtils.FLAG_VALUES.contains((Object)part.trim())) continue;
                    throw new AlarmDefinitionValidationException(part + " is not a valid flag");
                }
                this.regexFlags = value;
                break;
            }
            case "severity": {
                if (value == null) {
                    this.severity = null;
                    return;
                }
                if (!Severity.asList().contains(value)) {
                    throw new AlarmDefinitionValidationException(value + " is not a valid severity value");
                }
                this.setSeverity(value);
                break;
            }
            case "logger": {
                this.logger = value;
                break;
            }
            case "thread": {
                this.thread = value;
                break;
            }
            case "type": {
                this.type = value;
                break;
            }
            default: {
                throw new AlarmDefinitionValidationException("unrecognized attribute: " + name);
            }
        }
    }

    private boolean doMatch(ILoggingEvent event) {
        int d;
        if (this.regex.matcher(event.getFormattedMessage()).find()) {
            return true;
        }
        int n = d = this.depth == null ? Integer.MAX_VALUE : this.depth - 1;
        if (this.matchException.booleanValue()) {
            for (IThrowableProxy p = event.getThrowableProxy(); p != null && d >= 0; p = p.getCause(), --d) {
                if (!this.regex.matcher(p.getMessage()).find()) continue;
                return true;
            }
        }
        return false;
    }
}

