/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms.dao.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.dcache.alarms.dao.ILogEntryDAO;
import org.dcache.alarms.dao.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNucleusLogEntryStore
implements ILogEntryDAO {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String xmlPath;
    private final Properties properties = new Properties();
    private PersistenceManagerFactory pmf;

    public DataNucleusLogEntryStore(String xmlPath, Properties properties) throws IOException {
        this.xmlPath = xmlPath;
        this.properties.putAll((Map<?, ?>)properties);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(LogEntry entry) {
        PersistenceManager insertManager = this.pmf.getPersistenceManager();
        Transaction tx = insertManager.currentTransaction();
        Query query = insertManager.newQuery(LogEntry.class);
        query.setFilter("key==k");
        query.declareParameters("java.lang.String k");
        query.addExtension("datanucleus.query.resultCacheType", (Object)"none");
        query.setIgnoreCache(true);
        query.getFetchPlan().setFetchSize(0);
        try {
            tx.begin();
            Collection dup = (Collection)query.executeWithArray(new Object[]{entry.getKey()});
            this.logger.trace("duplicate? {}", (Object)dup);
            if (dup != null && !dup.isEmpty()) {
                if (dup.size() > 1) {
                    throw new RuntimeException("data store inconsistency! more than one alarm with the same id: " + entry.getKey());
                }
                LogEntry original = (LogEntry)dup.iterator().next();
                original.setLastUpdate(entry.getLastUpdate());
                original.setReceived(original.getReceived() + 1);
                original.setClosed(false);
            } else {
                this.logger.trace("makePersistent alarm, key={}", (Object)entry.getKey());
                insertManager.makePersistent((Object)entry);
                this.logger.trace("committing");
            }
            tx.commit();
            this.logger.debug("finished putting alarm, key={}", (Object)entry.getKey());
        }
        finally {
            try {
                if (tx.isActive()) {
                    tx.rollback();
                }
            }
            finally {
                insertManager.close();
            }
        }
    }

    private void initialize() throws IOException {
        if (this.properties.getProperty("datanucleus.ConnectionURL").startsWith("xml:")) {
            this.initializeXmlFile();
        }
        this.properties.put("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.api.jdo.JDOPersistenceManagerFactory");
        this.pmf = JDOHelper.getPersistenceManagerFactory((Map)this.properties);
    }

    private void initializeXmlFile() throws IOException {
        File file = new File(this.xmlPath);
        if (!file.exists()) {
            if (!file.getParentFile().isDirectory()) {
                String parent = file.getParentFile().getAbsolutePath();
                throw new FileNotFoundException(parent + " is not a directory");
            }
            try (PrintWriter pw = new PrintWriter(new FileWriter(file));){
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.println("<entries></entries>");
                pw.flush();
            }
        }
    }
}

