/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms.dao;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dcache.alarms.IAlarms;
import org.dcache.alarms.Severity;
import org.dcache.alarms.logback.AlarmDefinition;
import org.dcache.util.IRegexFilterable;

public class LogEntry
implements IAlarms,
Comparable<LogEntry>,
IRegexFilterable {
    private static final long serialVersionUID = -8477649423971508910L;
    private static final String FORMAT = "E MMM dd HH:mm:ss zzz yyyy";
    @Nonnull
    private String key;
    private Long firstArrived;
    private Long lastUpdate;
    private String type;
    private Integer severity;
    private String host;
    private String domain;
    private String service;
    private String info;
    private String notes;
    private Boolean closed = false;
    private Boolean alarm = false;
    private Integer received = 1;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    @Override
    public int compareTo(LogEntry o) {
        Preconditions.checkNotNull((Object)o, (Object)"alarm entry parameter was null");
        return LogEntry.jdoGetkey(this).compareTo(LogEntry.jdoGetkey(o));
    }

    public boolean equals(Object other) {
        if (!(other instanceof LogEntry)) {
            return false;
        }
        return LogEntry.jdoGetkey(this).equals(LogEntry.jdoGetkey((LogEntry)other));
    }

    public Date getDateOfFirstArrival() {
        return new Date(LogEntry.jdoGetfirstArrived(this));
    }

    public Date getDateOfLastUpdate() {
        return new Date(LogEntry.jdoGetlastUpdate(this));
    }

    public String getDomain() {
        return LogEntry.jdoGetdomain(this);
    }

    public Long getFirstArrived() {
        return LogEntry.jdoGetfirstArrived(this);
    }

    public String getFormattedDateOfFirstArrival() {
        return LogEntry.getFormattedDate(this.getDateOfFirstArrival());
    }

    public String getFormattedDateOfLastUpdate() {
        return LogEntry.getFormattedDate(this.getDateOfLastUpdate());
    }

    public String getHost() {
        return LogEntry.jdoGethost(this);
    }

    public String getInfo() {
        return LogEntry.jdoGetinfo(this);
    }

    public String getKey() {
        return LogEntry.jdoGetkey(this);
    }

    public Long getLastUpdate() {
        return LogEntry.jdoGetlastUpdate(this);
    }

    public String getNotes() {
        return LogEntry.jdoGetnotes(this);
    }

    public Integer getReceived() {
        return LogEntry.jdoGetreceived(this);
    }

    public String getService() {
        return LogEntry.jdoGetservice(this);
    }

    public Integer getSeverity() {
        return LogEntry.jdoGetseverity(this);
    }

    public Severity getSeverityEnum() {
        return Severity.fromOrdinal(LogEntry.jdoGetseverity(this));
    }

    public String getType() {
        return LogEntry.jdoGettype(this);
    }

    public int hashCode() {
        return LogEntry.jdoGetkey(this).hashCode();
    }

    public Boolean isAlarm() {
        return LogEntry.jdoGetalarm(this);
    }

    public Boolean isClosed() {
        return LogEntry.jdoGetclosed(this);
    }

    public void setAlarm(Boolean alarm) {
        LogEntry.jdoSetalarm(this, alarm);
    }

    public void setAlarmMetadata(ILoggingEvent event, AlarmDefinition definition) {
        Level level = event.getLevel();
        if (definition == null) {
            this.setSeverity(LogEntry.getSeverityFromLevel(level).ordinal());
            if (LogEntry.jdoGetalarm(this).booleanValue()) {
                this.setType(event.getMarker().toString());
            } else {
                this.setType(level.toString());
            }
            this.setKey(UUID.randomUUID().toString());
        } else {
            this.setSeverity(definition.getSeverityEnum().ordinal());
            this.setType(definition.getType());
            this.setKey(definition.getKey(event, LogEntry.jdoGethost(this), LogEntry.jdoGetdomain(this), LogEntry.jdoGetservice(this)));
        }
    }

    public void setClosed(Boolean closed) {
        LogEntry.jdoSetclosed(this, closed);
    }

    public void setDateOfFirstArrival(Date date) {
        LogEntry.jdoSetfirstArrived(this, date.getTime());
    }

    public void setDateOfLastUpdate(Date date) {
        LogEntry.jdoSetlastUpdate(this, date.getTime());
    }

    public void setDomain(String domain) {
        LogEntry.jdoSetdomain(this, domain);
    }

    public void setFirstArrived(Long timestamp) {
        LogEntry.jdoSetfirstArrived(this, timestamp);
    }

    public void setHost(String host) {
        LogEntry.jdoSethost(this, host);
    }

    public void setInfo(String info) {
        LogEntry.jdoSetinfo(this, info);
    }

    public void setKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        LogEntry.jdoSetkey(this, key);
    }

    public void setLastUpdate(Long lastUpdate) {
        LogEntry.jdoSetlastUpdate(this, lastUpdate);
    }

    public void setNotes(String notes) {
        LogEntry.jdoSetnotes(this, notes);
    }

    public void setReceived(Integer received) {
        LogEntry.jdoSetreceived(this, received);
    }

    public void setService(String service) {
        LogEntry.jdoSetservice(this, service);
    }

    public void setSeverity(Integer severity) {
        LogEntry.jdoSetseverity(this, severity);
    }

    public void setType(String type) {
        LogEntry.jdoSettype(this, type);
    }

    public String toFilterableString() {
        return this.getFormattedDateOfFirstArrival() + " " + this.getFormattedDateOfLastUpdate() + " " + LogEntry.jdoGettype(this) + " " + (Object)((Object)this.getSeverityEnum()) + " " + LogEntry.jdoGetreceived(this) + " " + LogEntry.jdoGethost(this) + " " + LogEntry.jdoGetdomain(this) + " " + LogEntry.jdoGetinfo(this) + " " + LogEntry.jdoGetservice(this) + " " + LogEntry.jdoGetnotes(this);
    }

    public String toString() {
        return this.toFilterableString();
    }

    public void update(LogEntry entry) {
        if (entry == null) {
            return;
        }
        LogEntry.jdoSetclosed(this, entry.isClosed());
        LogEntry.jdoSetnotes(this, entry.getNotes());
    }

    private static String getFormattedDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT);
        format.setLenient(false);
        return format.format(date);
    }

    private static Severity getSeverityFromLevel(Level level) {
        switch (level.toInt()) {
            case 40000: {
                return Severity.HIGH;
            }
            case 30000: {
                return Severity.MODERATE;
            }
        }
        return Severity.LOW;
    }

    static {
        jdoFieldNames = LogEntry.__jdoFieldNamesInit();
        jdoFieldTypes = LogEntry.__jdoFieldTypesInit();
        jdoFieldFlags = LogEntry.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = LogEntry.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = LogEntry.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)LogEntry.___jdo$loadClass("org.dcache.alarms.dao.LogEntry"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new LogEntry());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(6, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        LogEntry result = new LogEntry();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        LogEntry result = new LogEntry();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.alarm = (Boolean)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.closed = (Boolean)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.domain = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.firstArrived = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.host = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.info = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.lastUpdate = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.notes = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.received = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.service = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.severity = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.type = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.alarm);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.closed);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.domain);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.firstArrived);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.host);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.info);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.lastUpdate);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.notes);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.received);
                break;
            }
            case 10: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.service);
                break;
            }
            case 11: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.severity);
                break;
            }
            case 12: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.type);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(LogEntry obj, int index) {
        switch (index) {
            case 0: {
                this.alarm = obj.alarm;
                break;
            }
            case 1: {
                this.closed = obj.closed;
                break;
            }
            case 2: {
                this.domain = obj.domain;
                break;
            }
            case 3: {
                this.firstArrived = obj.firstArrived;
                break;
            }
            case 4: {
                this.host = obj.host;
                break;
            }
            case 5: {
                this.info = obj.info;
                break;
            }
            case 6: {
                this.key = obj.key;
                break;
            }
            case 7: {
                this.lastUpdate = obj.lastUpdate;
                break;
            }
            case 8: {
                this.notes = obj.notes;
                break;
            }
            case 9: {
                this.received = obj.received;
                break;
            }
            case 10: {
                this.service = obj.service;
                break;
            }
            case 11: {
                this.severity = obj.severity;
                break;
            }
            case 12: {
                this.type = obj.type;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof LogEntry)) {
            throw new IllegalArgumentException("object is not an object of type org.dcache.alarms.dao.LogEntry");
        }
        LogEntry other = (LogEntry)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"alarm", "closed", "domain", "firstArrived", "host", "info", "key", "lastUpdate", "notes", "received", "service", "severity", "type"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{LogEntry.___jdo$loadClass("java.lang.Boolean"), LogEntry.___jdo$loadClass("java.lang.Boolean"), LogEntry.___jdo$loadClass("java.lang.String"), LogEntry.___jdo$loadClass("java.lang.Long"), LogEntry.___jdo$loadClass("java.lang.String"), LogEntry.___jdo$loadClass("java.lang.String"), LogEntry.___jdo$loadClass("java.lang.String"), LogEntry.___jdo$loadClass("java.lang.Long"), LogEntry.___jdo$loadClass("java.lang.String"), LogEntry.___jdo$loadClass("java.lang.Integer"), LogEntry.___jdo$loadClass("java.lang.String"), LogEntry.___jdo$loadClass("java.lang.Integer"), LogEntry.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 24, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 13;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        LogEntry o = (LogEntry)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }

    private static Boolean jdoGetalarm(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Boolean)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.alarm);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"alarm\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.alarm;
    }

    private static void jdoSetalarm(LogEntry objPC, Boolean val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.alarm, (Object)val);
        } else {
            objPC.alarm = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Boolean jdoGetclosed(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Boolean)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.closed);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"closed\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.closed;
    }

    private static void jdoSetclosed(LogEntry objPC, Boolean val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.closed, (Object)val);
        } else {
            objPC.closed = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetdomain(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.domain);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"domain\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.domain;
    }

    private static void jdoSetdomain(LogEntry objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.domain, val);
        } else {
            objPC.domain = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static Long jdoGetfirstArrived(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.firstArrived);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"firstArrived\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.firstArrived;
    }

    private static void jdoSetfirstArrived(LogEntry objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.firstArrived, (Object)val);
        } else {
            objPC.firstArrived = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGethost(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.host);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"host\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.host;
    }

    private static void jdoSethost(LogEntry objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.host, val);
        } else {
            objPC.host = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetinfo(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.info);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"info\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.info;
    }

    private static void jdoSetinfo(LogEntry objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.info, val);
        } else {
            objPC.info = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetkey(LogEntry objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(LogEntry objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(6);
        }
    }

    private static Long jdoGetlastUpdate(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.lastUpdate);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"lastUpdate\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.lastUpdate;
    }

    private static void jdoSetlastUpdate(LogEntry objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.lastUpdate, (Object)val);
        } else {
            objPC.lastUpdate = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGetnotes(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.notes);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"notes\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.notes;
    }

    private static void jdoSetnotes(LogEntry objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.notes, val);
        } else {
            objPC.notes = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static Integer jdoGetreceived(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.received);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"received\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.received;
    }

    private static void jdoSetreceived(LogEntry objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.received, (Object)val);
        } else {
            objPC.received = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static String jdoGetservice(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 10, objPC.service);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"service\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.service;
    }

    private static void jdoSetservice(LogEntry objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 10, objPC.service, val);
        } else {
            objPC.service = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static Integer jdoGetseverity(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 11, (Object)objPC.severity);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"severity\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.severity;
    }

    private static void jdoSetseverity(LogEntry objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 11, (Object)objPC.severity, (Object)val);
        } else {
            objPC.severity = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static String jdoGettype(LogEntry objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 12, objPC.type);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"type\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.type;
    }

    private static void jdoSettype(LogEntry objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 12, objPC.type, val);
        } else {
            objPC.type = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }
}

