/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms.commandline;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dmg.util.Args;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import org.dcache.alarms.commandline.AlarmDefinitionManager;
import org.dcache.alarms.logback.AlarmDefinition;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class SendAlarm {
    private static final String CONFIG = "org/dcache/alarms/commandline/logback.xml";
    private static final String HELP = "help";
    private static final String HELP_ABBR = "h";
    private static final String LOCAL_HOST;
    private static final String LBRK;
    private static final String INDENT = "   ";

    public static void main(String[] args) {
        try {
            Args options = new Args(args);
            if (options.hasOption(HELP_ABBR) || options.hasOption(HELP)) {
                SendAlarm.printHelp();
            } else {
                AlarmArguments alarmArgs = new AlarmArguments(options);
                System.out.println("sending alarm to " + alarmArgs.destinationHost + ":" + alarmArgs.destinationPort);
                SendAlarm.sendAlarm(alarmArgs);
            }
        }
        catch (Throwable t) {
            AlarmDefinitionManager.printError(t);
        }
    }

    private static Logger configureLogger(String host, String port) throws JoranException {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"Commandline");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.reset();
        lc.putProperty("remote.server.host", host);
        lc.putProperty("remote.server.port", port);
        lc.putProperty("remote.log.level", Level.DEBUG.toString());
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        URL logbackConfig = Thread.currentThread().getContextClassLoader().getResource(CONFIG);
        configurator.doConfigure(logbackConfig);
        return logger;
    }

    private static void printHelp() {
        StringBuilder message = new StringBuilder();
        message.append("COMMAND LINE: dcache alarm ").append("[<options>] message:").append(LBRK).append(INDENT).append("OPTIONS:").append(LBRK);
        for (String help : AlarmArguments.HELP_MESSAGES.values()) {
            message.append(INDENT).append(help).append(LBRK);
        }
        message.append(INDENT).append("('dcache send' automatically provides destination uri").append(" based on dcache.log.server.host and dcache.log.server.port)").append(LBRK);
        System.out.println(message);
    }

    private static void sendAlarm(AlarmArguments alarmArgs) throws JoranException {
        MDC.put((String)"host", (String)alarmArgs.sourceHost);
        MDC.put((String)"domain", (String)alarmArgs.sourceDomain);
        MDC.put((String)"service", (String)alarmArgs.sourceService);
        Logger logger = SendAlarm.configureLogger(alarmArgs.destinationHost, alarmArgs.destinationPort);
        if (Level.ERROR.equals(alarmArgs.level)) {
            logger.error(alarmArgs.marker, alarmArgs.message);
        } else if (Level.WARN.equals(alarmArgs.level)) {
            logger.warn(alarmArgs.marker, alarmArgs.message);
        } else if (Level.INFO.equals(alarmArgs.level)) {
            logger.info(alarmArgs.marker, alarmArgs.message);
        } else if (Level.DEBUG.equals(alarmArgs.level)) {
            logger.debug(alarmArgs.marker, alarmArgs.message);
        }
    }

    static {
        String host;
        LBRK = System.getProperty("line.separator");
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            host = "<unknown host>";
        }
        LOCAL_HOST = host;
    }

    private static class AlarmArguments {
        private static final String DEFAULT_SOURCE_PATH = "/NA/command-line";
        private static final String DEFAULT_SOURCE = "src://" + SendAlarm.access$000() + "/NA/command-line";
        private static final String DEFAULT_PORT = "60001";
        private static final String LEVEL = "l";
        private static final String TYPE = "t";
        private static final String SOURCE = "s";
        private static final String DESTINATION = "d";
        private static final Map<String, String> HELP_MESSAGES = ImmutableMap.of((Object)"l", (Object)"-l=<level>       (optional): logging level [WARN, ERROR (default)]", (Object)"t", (Object)"-t=<type>        (optional): alarm subtype tag", (Object)"s", (Object)"-s=<source>      (optional): source info uri (i.e., \"src://[host]/[domain]/[service]\")", (Object)"d", (Object)"-d=<destination> (required): logging server uri (i.e., \"dst://[host]:[port]\"; port may be blank)");
        private final Level level;
        private final Marker marker;
        private final String sourceHost;
        private final String sourceService;
        private final String sourceDomain;
        private final String destinationHost;
        private final String destinationPort;
        private final String message;

        private AlarmArguments(Args parsed) throws Exception {
            ImmutableList arguments = parsed.getArguments();
            Preconditions.checkArgument((arguments.size() > 0 ? 1 : 0) != 0, (Object)"please provide a non-zero-length alarm message; -h[elp] for options");
            Iterator it = arguments.iterator();
            StringBuilder msg = new StringBuilder((String)it.next());
            while (it.hasNext()) {
                msg.append(" ").append((String)it.next());
            }
            this.message = msg.toString();
            String arg = parsed.getOption(DESTINATION);
            Preconditions.checkNotNull((Object)arg, (Object)("please provide a uri:" + LBRK + SendAlarm.INDENT + HELP_MESSAGES.get(DESTINATION) + "; -h[elp] for options"));
            URI uri = new URI(arg);
            this.destinationHost = uri.getHost();
            Preconditions.checkNotNull((Object)this.destinationHost, (Object)("please provide a host in the uri:" + LBRK + SendAlarm.INDENT + HELP_MESSAGES.get(DESTINATION) + "; -h[elp] for other options"));
            arg = String.valueOf(uri.getPort());
            this.destinationPort = "-1".equals(arg) ? DEFAULT_PORT : arg;
            arg = parsed.getOption(SOURCE);
            uri = arg != null ? new URI(arg) : new URI(DEFAULT_SOURCE);
            arg = uri.getHost();
            if (arg == null) {
                arg = LOCAL_HOST;
            }
            this.sourceHost = arg;
            arg = uri.getPath();
            if (arg == null || arg.isEmpty()) {
                arg = DEFAULT_SOURCE_PATH;
            }
            String[] parts = arg.substring(1).split("[/]");
            this.sourceDomain = parts[0];
            this.sourceService = parts.length > 1 ? parts[1] : this.sourceDomain;
            this.marker = AlarmDefinition.getMarker(parsed.getOption(TYPE));
            arg = parsed.getOption(LEVEL);
            this.level = arg == null ? Level.ERROR : Level.valueOf((String)arg);
        }
    }
}

