/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms.commandline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dcache.alarms.AlarmDefinitionValidationException;
import org.dcache.alarms.logback.AlarmDefinition;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AlarmDefinitionManager {
    public static final String ADD_CMD = "add";
    public static final String MODIFY_CMD = "modify";
    public static final String REMOVE_CMD = "remove";
    private static final String PROMPT = ">>  ";
    private static final String ERROR_PROMPT = "--> cause: ";
    private static final String MAIN_MSG = "Choose attribute to define, 'h[elp]' to describe attributes, 'q[uit]' to abort, return to process the definition.";
    private static final String ABORT_MSG = "quitting";
    private static final String REMOVE_MSG = "Alarm type to remove:";
    private static final String MODIFY_MSG = "Alarm type to modify:";
    private static final String NO_SUCH_ELEMENT_MSG = "No such alarm definition";
    private static final String INVALID_MSG = "incomplete or invalid definition";

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                throw new IllegalArgumentException("requires two arguments: [add, modify, remove] [path to xml]");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            File xmlFile = AlarmDefinitionManager.getXmlFile(args[1]);
            Element root = AlarmDefinitionManager.getRootElement(xmlFile);
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            switch (args[0]) {
                case "add": {
                    AlarmDefinitionManager.configure(new AlarmDefinition(), reader, outputter, root, xmlFile);
                    break;
                }
                case "modify": {
                    String input = AlarmDefinitionManager.getInput(MODIFY_MSG, reader);
                    if (input == null) break;
                    Element toUpdate = AlarmDefinitionManager.remove(input, root);
                    if (toUpdate == null) {
                        System.out.println(NO_SUCH_ELEMENT_MSG);
                        if (AlarmDefinitionManager.proceedWith("Add", reader)) {
                            AlarmDefinitionManager.configure(new AlarmDefinition(), reader, outputter, root, xmlFile);
                            break;
                        }
                        System.out.println(ABORT_MSG);
                        break;
                    }
                    AlarmDefinitionManager.printDefinition(toUpdate, outputter);
                    AlarmDefinitionManager.configure(new AlarmDefinition(toUpdate), reader, outputter, root, xmlFile);
                    break;
                }
                case "remove": {
                    String input = AlarmDefinitionManager.getInput(REMOVE_MSG, reader);
                    if (input == null) break;
                    Element toRemove = AlarmDefinitionManager.remove(input, root);
                    if (toRemove == null) {
                        System.out.println(NO_SUCH_ELEMENT_MSG);
                        System.out.println(ABORT_MSG);
                        break;
                    }
                    AlarmDefinitionManager.printDefinition(toRemove, outputter);
                    if (AlarmDefinitionManager.proceedWith("OK to delete", reader)) {
                        AlarmDefinitionManager.update(outputter, root, xmlFile);
                        break;
                    }
                    System.out.println(ABORT_MSG);
                }
            }
        }
        catch (Throwable e) {
            AlarmDefinitionManager.printError(e);
            System.exit(1);
        }
    }

    static void printError(Throwable t) {
        if (t != null) {
            if (t instanceof NullPointerException) {
                t.printStackTrace();
            } else {
                System.err.println(t.getMessage());
            }
            t = t.getCause();
        }
        while (t != null) {
            System.err.println(ERROR_PROMPT + t.getMessage());
            t = t.getCause();
        }
    }

    private static void configure(AlarmDefinition definition, BufferedReader reader, XMLOutputter outputter, Element rootNode, File xmlFile) throws Exception {
        while (true) {
            if ((definition = AlarmDefinitionManager.getDefinition(definition, reader)) == null) {
                return;
            }
            try {
                definition.validate();
                Element alarmType = definition.toElement();
                AlarmDefinitionManager.printDefinition(alarmType, outputter);
                if (AlarmDefinitionManager.proceedWith("Add/Update definition", reader)) {
                    AlarmDefinitionManager.update(alarmType, outputter, rootNode, xmlFile);
                    break;
                }
                System.out.println("Quit? <q>:");
                if (!reader.readLine().equalsIgnoreCase("q")) continue;
            }
            catch (AlarmDefinitionValidationException e) {
                System.out.println(e.getMessage());
                System.out.println(INVALID_MSG);
                continue;
            }
            break;
        }
    }

    private static AlarmDefinition getDefinition(AlarmDefinition definition, BufferedReader reader) throws IOException {
        block10: while (true) {
            System.out.println(MAIN_MSG);
            String input = AlarmDefinitionManager.getInput("Attributes: " + AlarmDefinition.ATTRIBUTES, reader);
            if (input == null) break;
            input = input.trim();
            switch (input.toLowerCase()) {
                case "h": 
                case "help": {
                    System.out.println(AlarmDefinition.getAttributesDescription());
                    continue block10;
                }
                case "q": 
                case "quit": {
                    System.out.println(ABORT_MSG);
                    return null;
                }
            }
            AlarmDefinitionManager.verifyInput(input, definition, reader);
        }
        return definition;
    }

    private static String getInput(String message, BufferedReader reader) throws IOException {
        System.out.println(message);
        System.out.print(PROMPT);
        String input = reader.readLine();
        if (input.isEmpty()) {
            return null;
        }
        return input;
    }

    private static Element getRootElement(File xmlFile) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(xmlFile);
        return document.getRootElement();
    }

    private static File getXmlFile(String path) throws IOException {
        File xmlFile = new File(path);
        if (!xmlFile.exists()) {
            throw new FileNotFoundException("not found: " + xmlFile.getAbsolutePath());
        }
        if (!xmlFile.isFile()) {
            throw new IOException("not a file: " + xmlFile.getAbsolutePath());
        }
        return xmlFile;
    }

    private static void printDefinition(Element alarmType, XMLOutputter outputter) throws IOException {
        System.out.println("Alarm Definition:");
        System.out.println("----------------------------------");
        outputter.output(alarmType, (OutputStream)System.out);
        System.out.println();
        System.out.println("----------------------------------");
    }

    private static boolean proceedWith(String question, BufferedReader reader) throws IOException {
        System.out.print(question);
        System.out.println("? <y/n> [n]:");
        String input = reader.readLine();
        return input.trim().equalsIgnoreCase("y");
    }

    private static Element remove(String type, Element rootNode) {
        List children = rootNode.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element alarmType = (Element)i.next();
            if (!type.equals(alarmType.getChild("type").getTextTrim())) continue;
            i.remove();
            return alarmType;
        }
        return null;
    }

    private static void update(Element definition, XMLOutputter outputter, Element rootNode, File xmlFile) throws JDOMException, IOException {
        String type = definition.getChild("type").getTextTrim();
        AlarmDefinitionManager.remove(type, rootNode);
        Element newRoot = new Element("definitions");
        newRoot.addContent((Collection)rootNode.cloneContent());
        newRoot.addContent((Content)definition);
        AlarmDefinitionManager.writeToFile(newRoot, outputter, xmlFile);
    }

    private static void update(XMLOutputter outputter, Element rootNode, File xmlFile) throws JDOMException, IOException {
        Element newRoot = new Element("definitions");
        newRoot.addContent((Collection)rootNode.cloneContent());
        AlarmDefinitionManager.writeToFile(newRoot, outputter, xmlFile);
    }

    private static void verifyInput(String option, AlarmDefinition definition, BufferedReader reader) throws IOException {
        try {
            System.out.println("(" + AlarmDefinition.getAttributeDescription(option) + ")");
        }
        catch (AlarmDefinitionValidationException e) {
            System.out.println(e.getMessage());
            return;
        }
        while (true) {
            try {
                String input = AlarmDefinitionManager.getInput("hit return to skip, - to remove value", reader);
                if (input == null) {
                    return;
                }
                definition.validateAndSet(option, input);
            }
            catch (AlarmDefinitionValidationException e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    private static void writeToFile(Element newRoot, XMLOutputter outputter, File xmlFile) throws IOException {
        Document newDocument = new Document();
        newDocument.setRootElement(newRoot);
        try (FileOutputStream stream = new FileOutputStream(xmlFile, false);){
            outputter.output(newDocument, (OutputStream)stream);
        }
    }
}

