/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles.transferManager;

import com.google.common.base.Preconditions;
import diskCacheV111.vehicles.IpProtocolInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.ietf.jgss.GSSException;

public class RemoteGsiftpTransferProtocolInfo
implements IpProtocolInfo {
    private static final long serialVersionUID = 7046410066693122355L;
    private final String name;
    private final int minor;
    private final int major;
    @Deprecated
    private final String[] hosts;
    @Deprecated
    private final int port;
    private InetSocketAddress addr;
    private final String gsiftpUrl;
    private long transferTime;
    private long bytesTransferred;
    private final String gsiftpTranferManagerName;
    private final String gsiftpTranferManagerDomain;
    private boolean emode = true;
    private int streams_num = 5;
    private int bufferSize;
    private int tcpBufferSize;
    @Deprecated
    private final Long requestCredentialId;
    private final String user;
    private PrivateKey key;
    private X509Certificate[] certChain;

    public RemoteGsiftpTransferProtocolInfo(String protocol, int major, int minor, InetSocketAddress addr, String gsiftpUrl, String gsiftpTranferManagerName, String gsiftpTranferManagerDomain, int bufferSize, int tcpBufferSize, @Deprecated Long requestCredentialId, GlobusGSSCredentialImpl credential) throws GSSException {
        this(protocol, major, minor, addr, gsiftpUrl, gsiftpTranferManagerName, gsiftpTranferManagerDomain, bufferSize, tcpBufferSize, requestCredentialId, credential, null);
    }

    public RemoteGsiftpTransferProtocolInfo(String protocol, int major, int minor, InetSocketAddress addr, String gsiftpUrl, String gsiftpTranferManagerName, String gsiftpTranferManagerDomain, int bufferSize, int tcpBufferSize, @Deprecated Long requestCredentialId, GlobusGSSCredentialImpl credential, String user) throws GSSException {
        Preconditions.checkArgument((boolean)(credential instanceof Serializable), (Object)"Credential must be Serializable");
        this.name = protocol;
        this.minor = minor;
        this.major = major;
        this.hosts = new String[]{addr.getHostString()};
        this.port = addr.getPort();
        this.addr = addr;
        this.gsiftpUrl = gsiftpUrl;
        this.gsiftpTranferManagerName = gsiftpTranferManagerName;
        this.gsiftpTranferManagerDomain = gsiftpTranferManagerDomain;
        this.bufferSize = bufferSize;
        this.tcpBufferSize = tcpBufferSize;
        this.requestCredentialId = requestCredentialId;
        this.user = user;
        this.key = credential.getPrivateKey();
        this.certChain = credential.getCertificateChain();
    }

    public String getGsiftpUrl() {
        return this.gsiftpUrl;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public String getProtocol() {
        return this.name;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public String getVersionString() {
        return this.name + "-" + this.major + "." + this.minor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionString());
        sb.append(this.addr.getAddress().getHostAddress());
        sb.append(':').append(this.addr.getPort());
        return sb.toString();
    }

    public boolean isFileCheckRequired() {
        return true;
    }

    public String getGsiftpTranferManagerName() {
        return this.gsiftpTranferManagerName;
    }

    public String getGsiftpTranferManagerDomain() {
        return this.gsiftpTranferManagerDomain;
    }

    public boolean isEmode() {
        return this.emode;
    }

    public void setEmode(boolean emode) {
        this.emode = emode;
    }

    public int getNumberOfStreams() {
        return this.streams_num;
    }

    public void setNumberOfStreams(int streams_num) {
        this.streams_num = streams_num;
    }

    public int getTcpBufferSize() {
        return this.tcpBufferSize;
    }

    public void setTcpBufferSize(int tcpBufferSize) {
        this.tcpBufferSize = tcpBufferSize;
    }

    @Deprecated
    public Long getRequestCredentialId() {
        return this.requestCredentialId;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.addr;
    }

    public GlobusGSSCredentialImpl getCredential() throws GSSException {
        return new GlobusGSSCredentialImpl(new X509Credential(this.key, this.certChain), 1);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.addr == null && this.hosts.length > 0) {
            this.addr = new InetSocketAddress(this.hosts[0], this.port);
        }
    }
}

