/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.IpProtocolInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;

public class RemoteHttpDataTransferProtocolInfo
implements IpProtocolInfo {
    private String name = "Unkown";
    private int minor;
    private int major;
    @Deprecated
    private String[] hosts;
    @Deprecated
    private int port;
    private InetSocketAddress addr;
    private int bufferSize;
    private String sourceHttpUrl;
    private long transferTime;
    private long bytesTransferred;
    private int sessionId;
    private static final long serialVersionUID = 4482469147378465931L;

    public RemoteHttpDataTransferProtocolInfo(String protocol, int major, int minor, InetSocketAddress addr, int buf_size, String sourceHttpUrl) {
        this.name = protocol;
        this.minor = minor;
        this.major = major;
        this.hosts = new String[]{addr.getHostString()};
        this.port = addr.getPort();
        this.addr = addr;
        this.sourceHttpUrl = sourceHttpUrl;
        this.bufferSize = buf_size;
    }

    public String getSourceHttpUrl() {
        return this.sourceHttpUrl;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public String getProtocol() {
        return this.name;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public String getVersionString() {
        return this.name + "-" + this.major + "." + this.minor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionString());
        sb.append(this.addr.getAddress().getHostAddress());
        sb.append(':').append(this.addr.getPort());
        return sb.toString();
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.addr;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.addr == null && this.hosts.length > 0) {
            this.addr = new InetSocketAddress(this.hosts[0], this.port);
        }
    }
}

