/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.vehicles.PoolMessage;

public class PoolStatusChangedMessage
extends PoolMessage {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int RESTART = 3;
    public static final String[] statusString = new String[]{"UNKNOWN", "UP", "DOWN", "RESTART"};
    private int _state;
    private PoolV2Mode _poolMode;
    private String _detailMessage;
    private int _detailCode;
    private static final long serialVersionUID = 7246217707829001604L;

    public PoolStatusChangedMessage(String poolName, int poolStatus) {
        super(poolName);
        if (poolStatus < 1 || poolStatus > 3) {
            throw new IllegalArgumentException("Not a valid pool status");
        }
        this._state = poolStatus;
    }

    public int getPoolState() {
        return this._state;
    }

    public String getPoolStatus() {
        return statusString[this._state];
    }

    @Override
    public String toString() {
        return "PoolName=" + this.getPoolName() + ";status=" + statusString[this._state] + (this._poolMode == null ? "" : ";mode=" + this._poolMode.toString()) + ";code=(" + this._detailCode + (this._detailMessage == null ? ")" : "," + this._detailMessage + ")");
    }

    public void setDetail(int code, String message) {
        this._detailCode = code;
        this._detailMessage = message;
    }

    public int getDetailCode() {
        return this._detailCode;
    }

    public String getDetailMessage() {
        return this._detailMessage;
    }

    public void setPoolMode(PoolV2Mode mode) {
        this._poolMode = mode;
    }

    public PoolV2Mode getPoolMode() {
        return this._poolMode;
    }
}

