/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.poolManager.RequestContainerV5;
import diskCacheV111.vehicles.PoolMgrSelectPoolMsg;
import diskCacheV111.vehicles.ProtocolInfo;
import java.io.Serializable;
import java.util.EnumSet;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PoolMgrSelectReadPoolMsg
extends PoolMgrSelectPoolMsg {
    private static final long serialVersionUID = -2126253028981131441L;
    private Context _context;

    public PoolMgrSelectReadPoolMsg(FileAttributes fileAttributes, ProtocolInfo protocolInfo, Context context) {
        this(fileAttributes, protocolInfo, context, RequestContainerV5.allStates);
        Preconditions.checkArgument((boolean)fileAttributes.isDefined(PoolMgrSelectReadPoolMsg.getRequiredAttributes()), (Object)"Required attributes are missing");
    }

    public PoolMgrSelectReadPoolMsg(FileAttributes fileAttributes, ProtocolInfo protocolInfo, Context context, EnumSet<RequestContainerV5.RequestState> allowedStates) {
        super(fileAttributes, protocolInfo, allowedStates);
        this._context = context == null ? new Context() : context;
    }

    public static EnumSet<FileAttribute> getRequiredAttributes() {
        return EnumSet.of(FileAttribute.PNFSID, new FileAttribute[]{FileAttribute.STORAGEINFO, FileAttribute.LOCATIONS, FileAttribute.SIZE, FileAttribute.ACCESS_LATENCY, FileAttribute.RETENTION_POLICY});
    }

    public Context getContext() {
        return this._context;
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public void setContext(int retryCounter, String previousStageHost, String previousStagePool) {
        this.setContext(new Context(retryCounter, previousStageHost, previousStagePool));
    }

    public static class Context
    implements Serializable {
        private static final long serialVersionUID = -1896293244725567276L;
        private final int _retryCounter;
        private final String _previousStageHost;
        private final String _previousStagePool;

        public Context() {
            this._retryCounter = 0;
            this._previousStageHost = null;
            this._previousStagePool = null;
        }

        public Context(int retryCounter, String previousStageHost, String previousStagePool) {
            this._retryCounter = retryCounter;
            this._previousStageHost = previousStageHost;
            this._previousStagePool = previousStagePool;
        }

        public int getRetryCounter() {
            return this._retryCounter;
        }

        public String getPreviousStageHost() {
            return this._previousStageHost;
        }

        public String getPreviousStagePool() {
            return this._previousStagePool;
        }
    }
}

