/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Objects;
import diskCacheV111.poolManager.PoolSelectionUnit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PoolLinkGroupInfo
implements Serializable {
    private static final long serialVersionUID = -1670253098493654055L;
    private final String _groupName;
    private final long _totalSpaceInBytes;
    private final long _availableSpaceInBytes;
    private final boolean _custodialAllowed;
    private final boolean _replicaAllowed;
    private final boolean _outputAllowed;
    private final boolean _nearlineAllowed;
    private final boolean _onlineAllowed;
    private final Map<String, Set<String>> _attributes = new HashMap<String, Set<String>>();

    public PoolLinkGroupInfo(PoolSelectionUnit.SelectionLinkGroup linkGroup, long totalSpace, long availableSpace) {
        this._groupName = linkGroup.getName();
        this._availableSpaceInBytes = availableSpace;
        this._totalSpaceInBytes = totalSpace;
        this._custodialAllowed = linkGroup.isCustodialAllowed();
        this._replicaAllowed = linkGroup.isReplicaAllowed();
        this._outputAllowed = linkGroup.isOutputAllowed();
        this._nearlineAllowed = linkGroup.isNearlineAllowed();
        this._onlineAllowed = linkGroup.isOnlineAllowed();
        Map<String, Set<String>> attributes = linkGroup.attributes();
        if (attributes != null) {
            this._attributes.putAll(attributes);
        }
    }

    public String getName() {
        return this._groupName;
    }

    public long getTotalSpace() {
        return this._totalSpaceInBytes;
    }

    public long getAvailableSpaceInBytes() {
        return this._availableSpaceInBytes;
    }

    @Deprecated
    public Set<String> getAttribute(String attribute) {
        return this._attributes.get(attribute);
    }

    public boolean isCustodialAllowed() {
        return this._custodialAllowed;
    }

    public boolean isOutputAllowed() {
        return this._outputAllowed;
    }

    public boolean isReplicaAllowed() {
        return this._replicaAllowed;
    }

    public boolean isOnlineAllowed() {
        return this._onlineAllowed;
    }

    public boolean isNearlineAllowed() {
        return this._nearlineAllowed;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("groupName", (Object)this._groupName).add("totalSpace", this._totalSpaceInBytes).add("availableSpace", this._availableSpaceInBytes).add("custodial", this._custodialAllowed).add("replica", this._replicaAllowed).add("output", this._outputAllowed).add("nearline", this._nearlineAllowed).add("online", this._onlineAllowed).add("attributes", this._attributes).toString();
    }
}

