/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.EnumSet;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PoolIoFileMessage
extends PoolMessage {
    private FileAttributes _fileAttributes;
    @Deprecated
    private StorageInfo _storageInfo;
    private ProtocolInfo _protocolInfo;
    @Deprecated
    private PnfsId _pnfsId;
    private boolean _isPool2Pool;
    private String _ioQueueName;
    private int _moverId;
    private String _initiator = "<undefined>";
    private boolean _forceSourceMode;
    private static final long serialVersionUID = -6549886547049510754L;

    public PoolIoFileMessage(String pool, ProtocolInfo protocolInfo, FileAttributes fileAttributes) {
        super(pool);
        Preconditions.checkNotNull((Object)fileAttributes);
        Preconditions.checkArgument((boolean)fileAttributes.isDefined(EnumSet.of(FileAttribute.STORAGEINFO, FileAttribute.PNFSID)));
        this._fileAttributes = fileAttributes;
        this._storageInfo = StorageInfos.extractFrom(fileAttributes);
        this._protocolInfo = protocolInfo;
        this._pnfsId = fileAttributes.getPnfsId();
    }

    public PoolIoFileMessage(String pool, PnfsId pnfsId, ProtocolInfo protocolInfo) {
        super(pool);
        this._protocolInfo = protocolInfo;
        this._pnfsId = pnfsId;
        this._fileAttributes = new FileAttributes();
        this._fileAttributes.setPnfsId(pnfsId);
    }

    public PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    public ProtocolInfo getProtocolInfo() {
        return this._protocolInfo;
    }

    public boolean isPool2Pool() {
        return this._isPool2Pool;
    }

    public void setPool2Pool() {
        this._isPool2Pool = true;
    }

    public void setIoQueueName(String ioQueueName) {
        this._ioQueueName = ioQueueName;
    }

    public String getIoQueueName() {
        return this._ioQueueName;
    }

    public int getMoverId() {
        return this._moverId;
    }

    public void setMoverId(int moverId) {
        this._moverId = moverId;
    }

    public void setInitiator(String initiator) {
        this._initiator = initiator;
    }

    public String getInitiator() {
        return this._initiator;
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._fileAttributes == null) {
            this._fileAttributes = new FileAttributes();
            if (this._storageInfo != null) {
                StorageInfos.injectInto(this._storageInfo, this._fileAttributes);
            }
            this._fileAttributes.setPnfsId(this._pnfsId);
        }
    }

    public void setForceSourceMode(boolean forceSourceMode) {
        this._forceSourceMode = forceSourceMode;
    }

    public boolean isForceSourceMode() {
        return this._forceSourceMode;
    }
}

