/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolMessage;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.dcache.vehicles.FileAttributes;

public class PoolFetchFileMessage
extends PoolMessage {
    private PnfsId _pnfsId;
    private StorageInfo _storageInfo;
    private FileAttributes _fileAttributes;
    private static final long serialVersionUID = 1856537534158868883L;

    public PoolFetchFileMessage(String poolName, FileAttributes fileAttributes) {
        super(poolName);
        this._fileAttributes = fileAttributes;
        this._pnfsId = fileAttributes.getPnfsId();
        this._storageInfo = StorageInfos.extractFrom(fileAttributes);
        this.setReplyRequired(true);
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._fileAttributes == null) {
            this._fileAttributes = new FileAttributes();
            if (this._storageInfo != null) {
                StorageInfos.injectInto(this._storageInfo, this._fileAttributes);
            }
            this._fileAttributes.setPnfsId(this._pnfsId);
        }
    }
}

