/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolMessage;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.EnumSet;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class Pool2PoolTransferMsg
extends PoolMessage {
    public static final int UNDETERMINED = 0;
    public static final int PRECIOUS = 1;
    public static final int CACHED = 2;
    private FileAttributes _fileAttributes;
    @Deprecated
    private PnfsId _pnfsId;
    @Deprecated
    private StorageInfo _storageInfo;
    private String _destinationPoolName;
    private int _destinationFileStatus = 0;
    private static final long serialVersionUID = -4227857007512530410L;

    public Pool2PoolTransferMsg(String sourcePoolName, String destinationPoolName, FileAttributes fileAttributes) {
        super(sourcePoolName);
        Preconditions.checkNotNull((Object)fileAttributes);
        Preconditions.checkArgument((boolean)fileAttributes.isDefined(EnumSet.of(FileAttribute.PNFSID)));
        this._fileAttributes = fileAttributes;
        this._pnfsId = fileAttributes.getPnfsId();
        if (fileAttributes.isDefined(FileAttribute.STORAGEINFO)) {
            this._storageInfo = StorageInfos.extractFrom(fileAttributes);
        }
        this._destinationPoolName = destinationPoolName;
        this.setReplyRequired(true);
    }

    public PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    public String getSourcePoolName() {
        return this.getPoolName();
    }

    public String getDestinationPoolName() {
        return this._destinationPoolName;
    }

    public void setDestinationFileStatus(int status) {
        this._destinationFileStatus = status;
    }

    public int getDestinationFileStatus() {
        return this._destinationFileStatus;
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    @Override
    public String toString() {
        return this.getPoolName() + ";pnfsid=" + this._fileAttributes.getPnfsId() + ";mode=" + (this._destinationFileStatus == 0 ? "Undetermined" : (this._destinationFileStatus == 1 ? "Precious" : "Cached"));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._fileAttributes == null) {
            this._fileAttributes = new FileAttributes();
            if (this._storageInfo != null) {
                StorageInfos.injectInto(this._storageInfo, this._fileAttributes);
            }
            this._fileAttributes.setPnfsId(this._pnfsId);
        }
    }
}

