/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PnfsFileInfoMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import org.stringtemplate.v4.ST;

public class MoverInfoMessage
extends PnfsFileInfoMessage {
    private long _dataTransferred;
    private long _connectionTime;
    private ProtocolInfo _protocolInfo;
    private boolean _fileCreated;
    private String _initiator = "<undefined>";
    private boolean _isP2p;
    private static final long serialVersionUID = -7013160118909496211L;

    public MoverInfoMessage(String cellName, PnfsId pnfsId) {
        super("transfer", "pool", cellName, pnfsId);
    }

    public void setFileCreated(boolean created) {
        this._fileCreated = created;
    }

    public void setTransferAttributes(long dataTransferred, long connectionTime, ProtocolInfo protocolInfo) {
        this._dataTransferred = dataTransferred;
        this._connectionTime = connectionTime;
        this._protocolInfo = protocolInfo;
    }

    public void setInitiator(String transaction) {
        this._initiator = transaction;
    }

    public void setP2P(boolean isP2p) {
        this._isP2p = isP2p;
    }

    public String getInitiator() {
        return this._initiator;
    }

    public long getDataTransferred() {
        return this._dataTransferred;
    }

    public long getConnectionTime() {
        return this._connectionTime;
    }

    public boolean isFileCreated() {
        return this._fileCreated;
    }

    public boolean isP2P() {
        return this._isP2p;
    }

    public ProtocolInfo getProtocolInfo() {
        return this._protocolInfo;
    }

    public String getAdditionalInfo() {
        return this._dataTransferred + " " + this._connectionTime + " " + this._fileCreated + " {" + this._protocolInfo + "} [" + this._initiator + "] ";
    }

    @Override
    public String toString() {
        return this.getInfoHeader() + " " + this.getFileInfo() + " " + this.getAdditionalInfo() + this.getResult();
    }

    @Override
    public void fillTemplate(ST template) {
        super.fillTemplate(template);
        template.add("transferred", (Object)this._dataTransferred);
        template.add("connectionTime", (Object)this._connectionTime);
        template.add("created", (Object)this._fileCreated);
        template.add("protocol", (Object)this._protocolInfo);
        template.add("initiator", (Object)this._initiator);
        template.add("p2p", (Object)this._isP2p);
    }
}

