/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import dmg.cells.nucleus.HasDiagnosticContext;
import java.io.Serializable;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.util.ReflectionUtils;

public class Message
implements Serializable,
HasDiagnosticContext {
    private boolean _replyRequired;
    private boolean _isReply;
    private int _returnCode;
    private Object _errorObject;
    private long _id;
    private Subject _subject;
    private static final long serialVersionUID = 2056896713066252504L;

    public Message() {
    }

    public Message(boolean replyRequired) {
        this._replyRequired = replyRequired;
    }

    public String toString() {
        return this._returnCode == 0 ? "" : "(" + this._returnCode + ")=" + this._errorObject;
    }

    public void setSucceeded() {
        this.setReply(0, null);
    }

    public void setFailed(int errorCode, Serializable errorObject) {
        this.setReply(errorCode, errorObject);
    }

    public void setReply() {
        this._isReply = true;
    }

    public void setReply(int returnCode, Serializable errorObject) {
        this._isReply = true;
        this._returnCode = returnCode;
        this._errorObject = errorObject;
    }

    public boolean isReply() {
        return this._isReply;
    }

    public void clearReply() {
        this._isReply = false;
        this._returnCode = 0;
        this._errorObject = null;
    }

    public int getReturnCode() {
        return this._returnCode;
    }

    public Serializable getErrorObject() {
        return (Serializable)this._errorObject;
    }

    public boolean getReplyRequired() {
        return this._replyRequired;
    }

    public void setReplyRequired(boolean replyRequired) {
        this._replyRequired = replyRequired;
    }

    public void setId(long id) {
        this._id = id;
    }

    public long getId() {
        return this._id;
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject getSubject() {
        return this._subject == null ? Subjects.ROOT : this._subject;
    }

    public String getMessageName() {
        String name = this.getClass().getSimpleName();
        int length = name.length();
        if (length > 7 && name.endsWith("Message")) {
            name = name.substring(0, name.length() - 7);
        } else if (length > 3 && name.endsWith("Msg")) {
            name = name.substring(0, name.length() - 3);
        }
        return name;
    }

    public String getDiagnosticContext() {
        String name = this.getMessageName();
        PnfsId id = ReflectionUtils.getPnfsId(this);
        return id == null ? name : name + " " + id;
    }

    public boolean invalidates(Message message) {
        return true;
    }

    public boolean fold(Message message) {
        return false;
    }
}

