/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.JobScheduler;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JobInfo
implements Serializable {
    private final String _client;
    private final long _clientId;
    private final long _submitTime;
    private final long _startTime;
    private final String _status;
    private final long _jobId;
    private static final SimpleDateFormat __format = new SimpleDateFormat("MM/dd-HH:mm:ss");
    private static final long serialVersionUID = 5209798222006083955L;

    public JobInfo(JobScheduler.Job job) {
        this(job, "<unknown>", 0L);
    }

    public JobInfo(JobScheduler.Job job, String clientName, long clientId) {
        this(job.getSubmitTime(), job.getStartTime(), job.getStatusString(), job.getJobId(), clientName, clientId);
    }

    public JobInfo(long submitTime, long startTime, String status, int id, String clientName, long clientId) {
        this._submitTime = submitTime;
        this._startTime = startTime;
        this._status = status;
        this._jobId = id;
        this._client = clientName;
        this._clientId = clientId;
    }

    public String getClientName() {
        return this._client;
    }

    public long getClientId() {
        return this._clientId;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getSubmitTime() {
        return this._submitTime;
    }

    public String getStatus() {
        return this._status;
    }

    public long getJobId() {
        return this._jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._jobId).append(";");
        sb.append(this._client).append(":").append(this._clientId);
        SimpleDateFormat simpleDateFormat = __format;
        synchronized (simpleDateFormat) {
            sb.append(";").append(__format.format(new Date(this._startTime))).append(";").append(__format.format(new Date(this._submitTime))).append(";").append(this._status).append(";");
        }
        return sb.toString();
    }
}

