/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.JobInfo;
import org.dcache.pool.classic.IoRequestState;
import org.dcache.pool.movers.Mover;

public class IoJobInfo
extends JobInfo {
    private final long _bytesTransferred;
    private final long _transferTime;
    private final long _lastTransferred;
    private final PnfsId _pnfsId;
    private static final long serialVersionUID = -7987228538353684951L;

    public IoJobInfo(long submitTime, long startTime, IoRequestState state, int id, Mover<?> transfer) {
        super(submitTime, startTime, state.toString(), id, transfer.getPathToDoor().getDestinationAddress().toString(), transfer.getClientId());
        this._pnfsId = transfer.getFileAttributes().getPnfsId();
        this._bytesTransferred = transfer.getBytesTransferred();
        this._transferTime = transfer.getTransferTime();
        this._lastTransferred = transfer.getLastTransferred();
    }

    public long getTransferTime() {
        return this._transferTime;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public long getLastTransferred() {
        return this._lastTransferred;
    }

    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    @Override
    public String toString() {
        return super.toString() + this._pnfsId + ";B=" + this._bytesTransferred + ";T=" + this._transferTime + ";L=" + (System.currentTimeMillis() - this._lastTransferred) / 1000L + ";";
    }
}

