/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.Transaction;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.security.auth.Subject;
import org.dcache.auth.SubjectWrapper;
import org.dcache.auth.Subjects;
import org.stringtemplate.v4.ST;

public class InfoMessage
implements Serializable {
    private static final SimpleDateFormat __dateFormat = new SimpleDateFormat("MM.dd HH:mm:ss");
    private final String _cellType;
    private String _messageType;
    private final String _cellName;
    private long _timeQueued;
    private int _resultCode;
    private String _message = "";
    private long _timestamp = System.currentTimeMillis();
    private String _transaction;
    private long _transactionID = Transaction.newID();
    private Subject _subject;
    private static final long serialVersionUID = -8035876156296337291L;

    public InfoMessage(String messageType, String cellType, String cellName) {
        this._cellName = cellName;
        this._cellType = cellType;
        this._messageType = messageType;
    }

    protected static synchronized String formatTimestamp(Date timestamp) {
        return __dateFormat.format(timestamp);
    }

    public String getInfoHeader() {
        return InfoMessage.formatTimestamp(new Date(this._timestamp)) + " [" + this._cellType + ":" + this._cellName + ":" + this._messageType + "]";
    }

    public String getResult() {
        return "{" + this._resultCode + ":\"" + this._message + "\"}";
    }

    public String toString() {
        return this.getInfoHeader() + " " + this.getResult();
    }

    public String getFormattedDate() {
        return InfoMessage.formatTimestamp(new Date(this._timestamp));
    }

    public void fillTemplate(ST template) {
        template.add("date", (Object)new Date(this.getTimestamp()));
        template.add("queuingTime", (Object)this.getTimeQueued());
        template.add("message", (Object)this.getMessage());
        template.add("type", (Object)this.getMessageType());
        template.add("cellName", (Object)this.getCellName());
        template.add("cellType", (Object)this.getCellType());
        template.add("rc", (Object)this.getResultCode());
        template.add("subject", (Object)new SubjectWrapper(this.getSubject()));
    }

    public void setResult(int resultCode, String resultMessage) {
        this._message = resultMessage;
        this._resultCode = resultCode;
    }

    public void setTimeQueued(long timeQueued) {
        this._timeQueued = timeQueued;
    }

    public long getTimeQueued() {
        return this._timeQueued;
    }

    public String getCellType() {
        return this._cellType;
    }

    public void setMessageType(String messageType) {
        this._messageType = messageType;
    }

    public String getMessageType() {
        return this._messageType;
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getMessage() {
        return this._message;
    }

    public int getResultCode() {
        return this._resultCode;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public synchronized void setTransaction(String transaction) {
        this._transaction = transaction;
    }

    public synchronized String getTransaction() {
        if (this._transaction == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCellType()).append(":").append(this.getCellName()).append(":");
            sb.append(this.getTimestamp()).append("-").append(this._transactionID);
            this._transaction = sb.toString();
        }
        return this._transaction;
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject getSubject() {
        return this._subject == null ? Subjects.ROOT : this._subject;
    }
}

