/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.IpProtocolInfo;
import java.net.InetSocketAddress;
import java.net.URI;

public class HttpProtocolInfo
implements IpProtocolInfo {
    private String _name = "Unkown";
    private int _minor;
    private int _major;
    @Deprecated
    private final String[] _hosts;
    @Deprecated
    private int _port;
    private InetSocketAddress _clientSocketAddress;
    private long _transferTime;
    private long _bytesTransferred;
    private int _sessionId;
    private boolean _writeAllowed;
    private String httpDoorCellName;
    private String httpDoorDomainName;
    private String path;
    private URI _location;
    private static final long serialVersionUID = 8002182588464502270L;

    public HttpProtocolInfo(String protocol, int major, int minor, InetSocketAddress clientSocketAddress, String httpDoorCellName, String httpDoorDomainName, String path, URI location) {
        this._name = protocol;
        this._minor = minor;
        this._major = major;
        this._hosts = new String[]{clientSocketAddress.getAddress().getHostAddress()};
        this._port = clientSocketAddress.getPort();
        this._clientSocketAddress = clientSocketAddress;
        this.httpDoorCellName = httpDoorCellName;
        this.httpDoorDomainName = httpDoorDomainName;
        this.path = path;
        this._location = location;
    }

    public String getHttpDoorCellName() {
        return this.httpDoorCellName;
    }

    public String getHttpDoorDomainName() {
        return this.httpDoorDomainName;
    }

    public String getPath() {
        return this.path;
    }

    public int getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(int sessionId) {
        this._sessionId = sessionId;
    }

    @Override
    public String getProtocol() {
        return this._name;
    }

    @Override
    public int getMinorVersion() {
        return this._minor;
    }

    @Override
    public int getMajorVersion() {
        return this._major;
    }

    @Override
    public String getVersionString() {
        return this._name + "-" + this._major + "." + this._minor;
    }

    public void setBytesTransferred(long bytesTransferred) {
        this._bytesTransferred = bytesTransferred;
    }

    public void setTransferTime(long transferTime) {
        this._transferTime = transferTime;
    }

    public long getTransferTime() {
        return this._transferTime;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionString());
        sb.append(this._clientSocketAddress.getAddress().getHostName());
        sb.append(':').append(this._clientSocketAddress.getPort());
        sb.append(':').append(this.httpDoorCellName);
        sb.append(':').append(this.httpDoorDomainName);
        sb.append(':').append(this.path);
        return sb.toString();
    }

    public boolean isWriteAllowed() {
        return this._writeAllowed;
    }

    public void setAllowWrite(boolean allow) {
        this._writeAllowed = allow;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this._clientSocketAddress;
    }

    public URI getLocation() {
        return this._location;
    }
}

