/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.dcache.vehicles.FileAttributes;

public class DoorTransferFinishedMessage
extends Message {
    private final ProtocolInfo _protocol;
    private FileAttributes _fileAttributes;
    @Deprecated
    private final StorageInfo _info;
    private final PnfsId _pnfsId;
    private final String _poolName;
    private final String _ioQueueName;
    private static final long serialVersionUID = -7563456962335030196L;

    public DoorTransferFinishedMessage(long id, PnfsId pnfsId, ProtocolInfo protocol, FileAttributes fileAttributes, String poolName, String ioQueueName) {
        this.setId(id);
        this._protocol = protocol;
        this._fileAttributes = fileAttributes;
        this._info = StorageInfos.extractFrom(fileAttributes);
        this._pnfsId = pnfsId;
        this._poolName = poolName;
        this._ioQueueName = ioQueueName;
    }

    public String getIoQueueName() {
        return this._ioQueueName;
    }

    public ProtocolInfo getProtocolInfo() {
        return this._protocol;
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    public String getPoolName() {
        return this._poolName;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._fileAttributes == null) {
            this._fileAttributes = new FileAttributes();
            if (this._info != null) {
                StorageInfos.injectInto(this._info, this._fileAttributes);
            }
            this._fileAttributes.setPnfsId(this._pnfsId);
        }
    }
}

