/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.IpProtocolInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;

public class DCapClientProtocolInfo
implements IpProtocolInfo {
    private String name = "Unkown";
    private int minor;
    private int major;
    @Deprecated
    private String[] hosts;
    @Deprecated
    private int port;
    private InetSocketAddress addr;
    private String gsiftpUrl;
    private long transferTime;
    private long bytesTransferred;
    private int sessionId;
    private String initiatorCellName;
    private String initiatorCellDomain;
    private long id;
    private int bufferSize;
    private int tcpBufferSize;
    private static final long serialVersionUID = -8861384829188018580L;

    public DCapClientProtocolInfo(String protocol, int major, int minor, InetSocketAddress addr, String initiatorCellName, String initiatorCellDomain, long id, int bufferSize, int tcpBufferSize) {
        this.name = protocol;
        this.minor = minor;
        this.major = major;
        this.addr = addr;
        this.hosts = new String[]{addr.getHostString()};
        this.port = addr.getPort();
        this.initiatorCellName = initiatorCellName;
        this.initiatorCellDomain = initiatorCellDomain;
        this.id = id;
        this.bufferSize = bufferSize;
        this.tcpBufferSize = tcpBufferSize;
    }

    public String getGsiftpUrl() {
        return this.gsiftpUrl;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public String getProtocol() {
        return this.name;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public String getVersionString() {
        return this.name + "-" + this.major + "." + this.minor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionString());
        sb.append(this.addr.getAddress().getHostAddress());
        sb.append(':').append(this.addr.getPort());
        return sb.toString();
    }

    public String getInitiatorCellName() {
        return this.initiatorCellName;
    }

    public String getInitiatorCellDomain() {
        return this.initiatorCellDomain;
    }

    public long getId() {
        return this.id;
    }

    public int getTcpBufferSize() {
        return this.tcpBufferSize;
    }

    public void setTcpBufferSize(int tcpBufferSize) {
        this.tcpBufferSize = tcpBufferSize;
    }

    public boolean isFileCheckRequired() {
        return true;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.addr;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.addr == null && this.hosts.length > 0) {
            this.addr = new InetSocketAddress(this.hosts[0], this.port);
        }
    }
}

