/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

public class UnitInteger {
    private static final String INFINITY = "Infinity";
    private static final long TEBI = 0x10000000000L;
    private static final long GIBI = 0x40000000L;
    private static final long MEBI = 0x100000L;
    private static final long KIBI = 1024L;
    private long _value;

    public UnitInteger(long value) {
        this._value = value;
    }

    public UnitInteger(String stringRep) {
        this._value = UnitInteger.parseUnitLong(stringRep);
    }

    public static long parseUnitLong(String stringRep) {
        String num;
        long multi;
        if (stringRep.length() < 1) {
            throw new IllegalArgumentException("Empty String");
        }
        if (stringRep.equals(INFINITY)) {
            return Long.MAX_VALUE;
        }
        switch (stringRep.charAt(stringRep.length() - 1)) {
            case 'K': 
            case 'k': {
                multi = 1024L;
                num = stringRep.substring(0, stringRep.length() - 1);
                break;
            }
            case 'M': 
            case 'm': {
                multi = 0x100000L;
                num = stringRep.substring(0, stringRep.length() - 1);
                break;
            }
            case 'G': 
            case 'g': {
                multi = 0x40000000L;
                num = stringRep.substring(0, stringRep.length() - 1);
                break;
            }
            case 'T': 
            case 't': {
                multi = 0x10000000000L;
                num = stringRep.substring(0, stringRep.length() - 1);
                break;
            }
            default: {
                multi = 1L;
                num = stringRep;
            }
        }
        return Long.parseLong(num) * multi;
    }

    public String toString() {
        return "" + this._value;
    }

    public String toUnitString() {
        return UnitInteger.toUnitString(this._value);
    }

    public static String toUnitString(long value) {
        if (value == Long.MAX_VALUE) {
            return INFINITY;
        }
        long tmp = value / 0x10000000000L;
        if (tmp > 0L && value % 0x10000000000L == 0L) {
            return Long.toString(tmp) + "T";
        }
        tmp = value / 0x40000000L;
        if (tmp > 0L && value % 0x40000000L == 0L) {
            return Long.toString(tmp) + "G";
        }
        tmp = value / 0x100000L;
        if (tmp > 0L && value % 0x100000L == 0L) {
            return Long.toString(tmp) + "M";
        }
        tmp = value / 1024L;
        if (tmp > 0L && value % 1024L == 0L) {
            return Long.toString(tmp) + "K";
        }
        return Long.toString(value);
    }

    public long longValue() {
        return this._value;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            UnitInteger ui = new UnitInteger(arg);
            System.out.println(arg + " -> " + ui.toUnitString() + "  (" + ui + ")");
        }
        System.exit(0);
    }
}

