/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.ThreadPool;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellAdapter;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dcache.util.CDCThreadFactory;
import org.dcache.util.FireAndForgetTask;

public class ThreadPoolNG
implements ThreadPool {
    private static final int CORE_SIZE = 0;
    private static final int MAX_SIZE = Integer.MAX_VALUE;
    private static final long KEEP_ALIVE = 60L;
    private final ThreadPoolExecutor _executor;

    public ThreadPoolNG(CellAdapter cell) {
        this._executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)cell.getNucleus());
    }

    public ThreadPoolNG() {
        ThreadFactory factory = Executors.defaultThreadFactory();
        this._executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new CDCThreadFactory(factory, CDC.getCellName(), CDC.getDomainName()));
    }

    @Override
    public int getCurrentThreadCount() {
        return this._executor.getActiveCount();
    }

    @Override
    public int getMaxThreadCount() {
        return this._executor.getMaximumPoolSize();
    }

    @Override
    public int getWaitingThreadCount() {
        return 0;
    }

    @Override
    public void invokeLater(final Runnable runner, String name) {
        final CDC cdc = new CDC();
        Runnable wrapper = new Runnable(){

            @Override
            public void run() {
                try (CDC ignored = cdc.restore();){
                    runner.run();
                }
            }
        };
        this._executor.execute(new FireAndForgetTask(wrapper));
    }

    @Override
    public void setMaxThreadCount(int maxThreadCount) throws IllegalArgumentException {
        if (maxThreadCount == 0) {
            maxThreadCount = Integer.MAX_VALUE;
        }
        this._executor.setMaximumPoolSize(maxThreadCount);
    }

    public String toString() {
        return "ThreadPoolNG $Revision: 1.4 $ max/active: " + this.getMaxThreadCount() + "/" + this.getCurrentThreadCount();
    }
}

