/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.vehicles.StorageInfo;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;

public class StorageInfoViewer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage ... <objFile> ... ");
            System.exit(4);
        }
        String[] arr$ = args;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                System.exit(0);
                return;
            }
            String filename = arr$[i$];
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(new File(filename)));
                try {
                    Object o;
                    while ((o = ois.readObject()) != null) {
                        int len$2;
                        String[] arr$2;
                        StorageInfo info;
                        System.out.println("------------------------------------------------");
                        System.out.println("Filename : " + filename);
                        System.out.println("Class    : " + o.getClass().getName());
                        System.out.println("Content  : ");
                        if (o instanceof StorageInfo) {
                            String[] flags;
                            info = (StorageInfo)o;
                            System.out.println("  HSM Type     : " + info.getHsm());
                            System.out.println("  StorageClass : " + info.getStorageClass());
                            System.out.println("  Bitfile Id   : " + info.getBitfileId());
                            String cacheClass = info.getCacheClass();
                            System.out.println("  Cache Class  : " + (cacheClass == null ? "None" : cacheClass));
                            System.out.println("  File Size    : " + info.getLegacySize());
                            System.out.println("  Created Only : " + info.isCreatedOnly());
                            System.out.println("  Stored       : " + info.isStored());
                            arr$2 = flags = new String[]{"flag-s", "flag-l", "flag-c"};
                            len$2 = arr$2.length;
                        } else {
                            System.out.println(o.toString());
                            continue;
                        }
                        for (int i$2 = 0; i$2 < len$2; ++i$2) {
                            String key = arr$2[i$2];
                            String value = info.getKey(key);
                            value = value == null ? "N.N" : value;
                            System.out.println("  Flag : " + key + " -> " + value);
                        }
                    }
                }
                catch (EOFException eofe) {
                }
                finally {
                    try {
                        ois.close();
                    }
                    catch (Exception ee) {}
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                System.out.println("Problem with file : " + filename + " : " + ee.getMessage());
            }
            ++i$;
        }
    }
}

