/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpreadAndWait
implements CellMessageAnswerable {
    private final CellEndpoint _endpoint;
    private final long _timeout;
    private int _pending;
    private final List<CellMessage> _replies = new ArrayList<CellMessage>();

    public SpreadAndWait(CellEndpoint endpoint, long timeout) {
        this._endpoint = endpoint;
        this._timeout = timeout;
    }

    public synchronized void send(CellMessage msg) {
        this._endpoint.sendMessage(msg, (CellMessageAnswerable)this, this._timeout);
        ++this._pending;
    }

    public synchronized void waitForReplies() throws InterruptedException {
        while (this._pending > 0) {
            this.wait();
        }
    }

    public synchronized void answerArrived(CellMessage request, CellMessage answer) {
        --this._pending;
        this._replies.add(answer);
        this.notifyAll();
    }

    public synchronized void exceptionArrived(CellMessage request, Exception exception) {
        --this._pending;
        this.notifyAll();
    }

    public synchronized void answerTimedOut(CellMessage request) {
        --this._pending;
        this.notifyAll();
    }

    public Iterator<CellMessage> getReplies() {
        return this._replies.iterator();
    }

    public int getReplyCount() {
        return this._replies.size();
    }

    public List<CellMessage> getReplyList() {
        return this._replies;
    }

    public synchronized CellMessage next() throws InterruptedException {
        while (this._pending > 0 && this._replies.isEmpty()) {
            this.wait();
        }
        if (this._pending == 0 && this._replies.isEmpty()) {
            return null;
        }
        return this._replies.remove(0);
    }
}

