/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.Batchable;
import diskCacheV111.util.JobScheduler;
import diskCacheV111.vehicles.JobInfo;
import dmg.cells.nucleus.CDC;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.dcache.commons.util.NDC;
import org.dcache.util.CDCThreadFactory;
import org.dcache.util.FifoPriorityComparator;
import org.dcache.util.FireAndForgetTask;
import org.dcache.util.IoPrioritizable;
import org.dcache.util.IoPriority;
import org.dcache.util.LifoPriorityComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJobScheduler
implements JobScheduler,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(SimpleJobScheduler.class);
    private static final int WAITING = 10;
    private static final int ACTIVE = 11;
    private static final int KILLED = 12;
    private static final int REMOVED = 13;
    private int _maxActiveJobs = 2;
    private int _activeJobs;
    private int _nextId = 1000;
    private final Object _lock = new Object();
    private final Thread _worker;
    private final Queue<SJob> _queue;
    private final Map<Integer, SJob> _jobs = new HashMap<Integer, SJob>();
    private int _batch = -1;
    private String _name = "regular";
    private int _id = -1;
    private String[] _st_string = new String[]{"W", "A", "K", "R"};
    private final ExecutorService _jobExecutor;

    public SimpleJobScheduler(String name) {
        this(Executors.defaultThreadFactory(), name, true);
    }

    public SimpleJobScheduler(String name, boolean fifo) {
        this(Executors.defaultThreadFactory(), name, fifo);
    }

    private SimpleJobScheduler(ThreadFactory factory, String name, boolean fifo) {
        this._name = name;
        this._queue = new PriorityQueue<SJob>(16, (Comparator)((Object)(fifo ? new FifoPriorityComparator() : new LifoPriorityComparator())));
        this._jobExecutor = Executors.newCachedThreadPool(new CDCThreadFactory(factory, CDC.getCellName(), CDC.getDomainName()){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = super.newThread(r);
                t.setName(SimpleJobScheduler.this._name + "-worker");
                return t;
            }
        });
        this._worker = factory.newThread(this);
        this._worker.setName(this._name);
        this._worker.start();
    }

    @Override
    public void setSchedulerId(int id) {
        this._id = id;
    }

    @Override
    public String getSchedulerName() {
        return this._name;
    }

    @Override
    public int getSchedulerId() {
        return this._id;
    }

    @Override
    public int add(Runnable runnable) throws InvocationTargetException {
        return this.add(runnable, IoPriority.REGULAR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(Runnable runnable, IoPriority priority) throws InvocationTargetException {
        Object object = this._lock;
        synchronized (object) {
            int n;
            if (this._id < 0) {
                int n2 = this._nextId;
                n = n2;
                this._nextId = n2 + 1;
            } else {
                n = this._nextId++ * 10 + this._id;
            }
            int id = n;
            try {
                if (runnable instanceof Batchable) {
                    ((Batchable)runnable).queued(id);
                }
            }
            catch (Throwable ee) {
                throw new InvocationTargetException(ee, "reported by queued");
            }
            if (this._maxActiveJobs <= 0) {
                _log.warn("A task was added to queue '" + this._name + "', however the queue is not configured to execute any tasks.");
            }
            SJob job = new SJob(runnable, id, priority);
            this._jobs.put(id, job);
            this._queue.add(job);
            this._lock.notifyAll();
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobInfo> getJobInfos() {
        Object object = this._lock;
        synchronized (object) {
            ArrayList<JobInfo> list = new ArrayList<JobInfo>();
            for (JobScheduler.Job job : this._jobs.values()) {
                list.add(job.getJobInfo());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobInfo getJobInfo(int jobId) {
        Object object = this._lock;
        synchronized (object) {
            JobScheduler.Job job = this._jobs.get(jobId);
            if (job == null) {
                throw new NoSuchElementException("Job not found : Job-" + jobId);
            }
            return job.getJobInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer printJobQueue(StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer(1024);
        }
        Object object = this._lock;
        synchronized (object) {
            for (JobScheduler.Job job : this._jobs.values()) {
                sb.append(job.toString()).append("\n");
            }
        }
        return sb;
    }

    @Override
    public void kill(int jobId, boolean force) throws NoSuchElementException {
        Object object = this._lock;
        synchronized (object) {
            SJob job = this._jobs.get(jobId);
            if (job == null) {
                throw new NoSuchElementException("Job not found : Job-" + jobId);
            }
            switch (job._status) {
                case 10: {
                    this.remove(jobId);
                    return;
                }
                case 11: {
                    job.kill(force);
                    return;
                }
            }
            throw new NoSuchElementException("Job is " + job.getStatusString() + " : Job-" + jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int jobId) throws NoSuchElementException {
        Object object = this._lock;
        synchronized (object) {
            SJob job = this._jobs.get(jobId);
            if (job == null) {
                throw new NoSuchElementException("Job not found : Job-" + jobId);
            }
            if (job._status != 10) {
                throw new NoSuchElementException("Job is " + job.getStatusString() + " : Job-" + jobId);
            }
            this._queue.remove(job);
            this._jobs.remove(job._id);
            if (job._runnable instanceof Batchable) {
                ((Batchable)job._runnable).unqueued();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobScheduler.Job getJob(int jobId) throws NoSuchElementException {
        Object object = this._lock;
        synchronized (object) {
            JobScheduler.Job job = this._jobs.get(jobId);
            if (job == null) {
                throw new NoSuchElementException("Job-" + jobId);
            }
            return job;
        }
    }

    @Override
    public int getQueueSize() {
        return this._queue.size();
    }

    @Override
    public int getActiveJobs() {
        return this._activeJobs;
    }

    @Override
    public int getMaxActiveJobs() {
        return this._maxActiveJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActiveJobs(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("new maximum value must be zero or greater");
        }
        Object object = this._lock;
        synchronized (object) {
            this._maxActiveJobs = max;
            this._lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this._lock;
        synchronized (object) {
            this._batch = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this._lock;
        synchronized (object) {
            this._batch = -1;
            this._lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(int batch) {
        Object object = this._lock;
        synchronized (object) {
            if (batch <= 0) {
                throw new IllegalArgumentException("batch <= 0");
            }
            this._batch = batch;
            this._lock.notifyAll();
        }
    }

    public int getBatchSize() {
        if (this._batch < 0) {
            throw new IllegalStateException("Not batching ....");
        }
        return this._batch;
    }

    @Override
    public void shutdown() {
        this._worker.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this._lock;
        synchronized (object) {
            try {
                try {
                    while (true) {
                        if (this._batch != 0) {
                            while (this._activeJobs < this._maxActiveJobs && !this._queue.isEmpty()) {
                                SJob job = this._queue.poll();
                                ++this._activeJobs;
                                this._batch = this._batch > 0 ? this._batch - 1 : this._batch;
                                job.start();
                            }
                        }
                        this._lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    for (SJob job : this._jobs.values()) {
                        if (job._status == 10) {
                            if (job._runnable instanceof Batchable) {
                                ((Batchable)job._runnable).unqueued();
                            }
                        } else if (job._status == 11) {
                            job.kill(true);
                        }
                        long start = System.currentTimeMillis();
                        while (this._activeJobs > 0 && System.currentTimeMillis() - start > 10000L) {
                            try {
                                this._lock.wait(1000L);
                            }
                            catch (InterruptedException ee) {}
                        }
                    }
                    this._jobExecutor.shutdownNow();
                }
            }
            catch (Throwable throwable) {
                this._jobExecutor.shutdownNow();
                throw throwable;
            }
        }
    }

    private class SJob
    implements JobScheduler.Job,
    Runnable,
    IoPrioritizable {
        private final long _submitTime = System.currentTimeMillis();
        private long _startTime;
        private int _status = 10;
        private final Runnable _runnable;
        private final int _id;
        private final IoPriority _priority;
        private Future<?> _future;
        private CDC _cdc;
        private final long _ctime;

        private SJob(Runnable runnable, int id, IoPriority priority) {
            this._runnable = runnable;
            this._id = id;
            this._priority = priority;
            this._cdc = new CDC();
            this._ctime = System.nanoTime();
        }

        @Override
        public int getJobId() {
            return this._id;
        }

        @Override
        public String getStatusString() {
            return SimpleJobScheduler.this._st_string[this._status - 10];
        }

        @Override
        public Runnable getTarget() {
            return this._runnable;
        }

        public int getId() {
            return this._id;
        }

        @Override
        public synchronized long getStartTime() {
            return this._startTime;
        }

        @Override
        public synchronized long getSubmitTime() {
            return this._submitTime;
        }

        public synchronized void start() {
            this._future = SimpleJobScheduler.this._jobExecutor.submit(new FireAndForgetTask(this));
            this._status = 11;
        }

        public synchronized boolean kill(boolean force) {
            if (this._future == null) {
                throw new IllegalStateException("Not running");
            }
            if (this._runnable instanceof Batchable) {
                if (((Batchable)this._runnable).kill()) {
                    return true;
                }
                if (!force) {
                    return false;
                }
            }
            this._future.cancel(true);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this;
            synchronized (object) {
                this._startTime = System.currentTimeMillis();
            }
            try {
                this._cdc.restore();
                NDC.push((String)("job=" + this._id));
                this._runnable.run();
            }
            finally {
                CDC.clear();
                object = this;
                synchronized (object) {
                    this._status = 13;
                }
                object = SimpleJobScheduler.this._lock;
                synchronized (object) {
                    SimpleJobScheduler.this._jobs.remove(this._id);
                    SimpleJobScheduler.this._activeJobs--;
                    SimpleJobScheduler.this._lock.notifyAll();
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._id).append(" ").append(this.getStatusString()).append(" ");
            sb.append((Object)this._priority).append(" ");
            if (this._runnable instanceof Batchable) {
                Batchable b = (Batchable)this._runnable;
                sb.append("{").append(b.getClient()).append(":").append(b.getClientId()).append("} ");
            }
            sb.append(this._runnable.toString());
            return sb.toString();
        }

        public int hashCode() {
            return this._id;
        }

        public boolean equals(Object o) {
            return o instanceof SJob && ((SJob)o)._id == this._id;
        }

        @Override
        public IoPriority getPriority() {
            return this._priority;
        }

        @Override
        public long getCreateTime() {
            return this._ctime;
        }

        @Override
        public JobInfo getJobInfo() {
            if (this._runnable instanceof Batchable) {
                JobInfo info = new JobInfo(this, ((Batchable)this._runnable).getClient(), ((Batchable)this._runnable).getClientId());
                return info;
            }
            return new JobInfo(this);
        }
    }
}

