/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunSystem
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(RunSystem.class);
    private static final Runtime __runtime = Runtime.getRuntime();
    private final String _exec;
    private final int _maxLines;
    private final long _timeout;
    private final Thread _readErrorThread;
    private final Thread _readOutputThread;
    private final Thread _processThread;
    private int _id = RunSystem.nextId();
    private Process _process;
    private int _stoppedReader;
    private boolean _processDone;
    private boolean _linesExceeded;
    private boolean _interrupted;
    private BufferedReader _stdout;
    private BufferedReader _stderr;
    private final PrintWriter _errorPrintWriter;
    private final PrintWriter _outputPrintWriter;
    private final StringWriter _errorStringWriter;
    private final StringWriter _outputStringWriter;
    private static int __counter = 100;

    private static synchronized int nextId() {
        return __counter++;
    }

    public RunSystem(String exec, int maxLines, long timeout) {
        this._exec = exec;
        this._maxLines = maxLines;
        this._timeout = timeout;
        this._readErrorThread = new Thread((Runnable)this, "error");
        this._readOutputThread = new Thread((Runnable)this, "output");
        this._processThread = new Thread((Runnable)this, "process");
        this._outputStringWriter = new StringWriter();
        this._errorStringWriter = new StringWriter();
        this._outputPrintWriter = new PrintWriter(this._outputStringWriter);
        this._errorPrintWriter = new PrintWriter(this._errorStringWriter);
    }

    private void say(String str) {
        if (_log.isDebugEnabled()) {
            _log.debug("[" + this._id + "] " + str);
        }
    }

    private void interruptReaders() {
        this._readOutputThread.interrupt();
        this._readErrorThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() throws IOException {
        this._process = __runtime.exec(this._exec);
        this._stdout = new BufferedReader(new InputStreamReader(this._process.getInputStream()));
        this._stderr = new BufferedReader(new InputStreamReader(this._process.getErrorStream()));
        this._process.getOutputStream().close();
        RunSystem runSystem = this;
        synchronized (runSystem) {
            block11: {
                this._readErrorThread.start();
                this._readOutputThread.start();
                this._processThread.start();
                try {
                    long rest;
                    long end = System.currentTimeMillis() + this._timeout;
                    while (!(this._stoppedReader >= 2 && this._processDone || (rest = end - System.currentTimeMillis()) <= 0L)) {
                        this.wait(rest);
                        this.say("Master : Wait returned : " + this.statusPrintout());
                    }
                }
                catch (InterruptedException ie) {
                    if (this._processDone) break block11;
                    this.say("Master : Destroying process");
                    this._process.destroy();
                }
            }
            this.say("Master : Wait stopped : " + this.statusPrintout());
            for (int l = 0; l < 20000; ++l) {
                this.say("Master : Wait loop " + l + " started");
                try {
                    long rest;
                    long end = System.currentTimeMillis() + 5000L;
                    while (!(this._stoppedReader >= 2 && this._processDone || (rest = end - System.currentTimeMillis()) <= 0L)) {
                        this.wait(rest);
                        this.say("Master : Wait 2 returned : " + this.statusPrintout());
                    }
                }
                catch (InterruptedException ie) {
                    this.say("Master : wait2 interrupted");
                }
                this.say("Master : Wait2 loop : " + l + " : " + this.statusPrintout());
                if (this._stoppedReader > 1 && this._processDone) break;
                if (!this._processDone) {
                    this.say("Master : Wait 2 loop : Destroying process");
                    this._process.destroy();
                }
                if (l <= 2 || this._stoppedReader >= 2) continue;
                this.say("Master : Wait 2 loop : Interrupting readers");
                this.interruptReaders();
            }
        }
    }

    private String statusPrintout() {
        return ";interrupt=" + this._interrupted + ";done=" + this._processDone + ";count=" + this._stoppedReader;
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._readErrorThread) {
            this.runReader(this._stderr, this._errorPrintWriter);
        } else if (Thread.currentThread() == this._readOutputThread) {
            this.runReader(this._stdout, this._outputPrintWriter);
        } else if (Thread.currentThread() == this._processThread) {
            this.runProcess();
        }
    }

    public String getErrorString() {
        return this._errorStringWriter.getBuffer().toString();
    }

    public String getOutputString() {
        return this._outputStringWriter.getBuffer().toString();
    }

    public int getExitValue() throws IllegalThreadStateException {
        return this._process.exitValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runProcess() {
        try {
            this.say("Process : waitFor called");
            int rr = this._process.waitFor();
            this.say("Process : waitFor returned =" + rr + "; waiting for sync");
        }
        catch (InterruptedException ie) {
            RunSystem runSystem = this;
            synchronized (runSystem) {
                this._interrupted = true;
                this.say("Process : waitFor was interrupted ");
            }
        }
        finally {
            RunSystem runSystem = this;
            synchronized (runSystem) {
                this._processDone = true;
                this.say("Process : done");
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReader(BufferedReader in, PrintWriter out) {
        int lines = 0;
        try {
            String line;
            this.say("Reader started");
            while (!Thread.interrupted() && (line = in.readLine()) != null) {
                if (lines++ >= this._maxLines) continue;
                out.println(line);
            }
        }
        catch (InterruptedIOException iioe) {
            this.say("Reader interruptedIoException");
        }
        catch (Exception ioe) {
            this.say("Reader Exception : " + ioe);
        }
        finally {
            this.say("Reader closing streams");
            try {
                in.close();
            }
            catch (IOException e) {}
            out.close();
            RunSystem e = this;
            synchronized (e) {
                this.say("Reader finished");
                if (lines >= this._maxLines) {
                    this.say("Lines (" + lines + ") have been truncated after " + this._maxLines);
                }
                ++this._stoppedReader;
                this.notifyAll();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage : ... <systemClass> <maxLines> <timeout>");
            System.exit(4);
        }
        long timeout = Long.parseLong(args[2]) * 1000L;
        int maxLines = Integer.parseInt(args[1]);
        RunSystem run = new RunSystem(args[0], maxLines, timeout);
        run.go();
        int rc = run.getExitValue();
        System.out.println("Exit Value : " + rc);
        System.out.println("--------------- Output ------------");
        System.out.println(run.getOutputString());
        System.out.println("--------------- Error ------------");
        System.out.println(run.getErrorString());
        System.exit(rc);
    }
}

