/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

public class PnfsIdUtil {
    private static final char[] valueToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static int hexToValue(byte val) {
        if (val >= 48 && val <= 57) {
            val = (byte)(val - 48);
            return val;
        }
        if (val >= 97 && val <= 102) {
            val = (byte)(val - 87);
            return val;
        }
        if (val >= 65 && val <= 70) {
            val = (byte)(val - 55);
            return val;
        }
        return -1;
    }

    public static byte[] toBinPnfsId(String pnfsid) {
        byte[] bb = pnfsid.getBytes();
        byte[] ba = new byte[bb.length / 2];
        ba[0] = (byte)(PnfsIdUtil.hexToValue(bb[2]) << 4 | PnfsIdUtil.hexToValue(bb[3]));
        ba[1] = (byte)(PnfsIdUtil.hexToValue(bb[0]) << 4 | PnfsIdUtil.hexToValue(bb[1]));
        ba[2] = (byte)(PnfsIdUtil.hexToValue(bb[6]) << 4 | PnfsIdUtil.hexToValue(bb[7]));
        ba[3] = (byte)(PnfsIdUtil.hexToValue(bb[4]) << 4 | PnfsIdUtil.hexToValue(bb[5]));
        ba[4] = (byte)(PnfsIdUtil.hexToValue(bb[14]) << 4 | PnfsIdUtil.hexToValue(bb[15]));
        ba[5] = (byte)(PnfsIdUtil.hexToValue(bb[12]) << 4 | PnfsIdUtil.hexToValue(bb[13]));
        ba[6] = (byte)(PnfsIdUtil.hexToValue(bb[10]) << 4 | PnfsIdUtil.hexToValue(bb[11]));
        ba[7] = (byte)(PnfsIdUtil.hexToValue(bb[8]) << 4 | PnfsIdUtil.hexToValue(bb[9]));
        ba[8] = (byte)(PnfsIdUtil.hexToValue(bb[22]) << 4 | PnfsIdUtil.hexToValue(bb[23]));
        ba[9] = (byte)(PnfsIdUtil.hexToValue(bb[20]) << 4 | PnfsIdUtil.hexToValue(bb[21]));
        ba[10] = (byte)(PnfsIdUtil.hexToValue(bb[18]) << 4 | PnfsIdUtil.hexToValue(bb[19]));
        ba[11] = (byte)(PnfsIdUtil.hexToValue(bb[16]) << 4 | PnfsIdUtil.hexToValue(bb[17]));
        return ba;
    }

    public static String toStringPnfsId(byte[] pnfsid) {
        int value;
        int i;
        char[] result = new char[2 * pnfsid.length];
        for (i = 0; i < 2; ++i) {
            value = pnfsid[1 - i] + 256 & 0xFF;
            result[2 * i] = valueToHex[value >> 4];
            result[2 * i + 1] = valueToHex[value & 0xF];
        }
        while (i < 4) {
            value = pnfsid[5 - i] + 256 & 0xFF;
            result[2 * i] = valueToHex[value >> 4];
            result[2 * i + 1] = valueToHex[value & 0xF];
            ++i;
        }
        while (i < 8) {
            value = pnfsid[11 - i] + 256 & 0xFF;
            result[2 * i] = valueToHex[value >> 4];
            result[2 * i + 1] = valueToHex[value & 0xF];
            ++i;
        }
        while (i < 12) {
            value = pnfsid[19 - i] + 256 & 0xFF;
            result[2 * i] = valueToHex[value >> 4];
            result[2 * i + 1] = valueToHex[value & 0xF];
            ++i;
        }
        return new String(result);
    }
}

