/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Pgpass {
    private String _pwdfile;
    private String _hostname;
    private String _port;
    private String _database;
    private String _username;

    public Pgpass(String pwdfile) {
        this._pwdfile = pwdfile;
    }

    private String process(String line, String hostname, String port, String database, String username) {
        String[] sa;
        if (line.charAt(0) != '#' && ((sa = line.split(":"))[0].equals("*") || sa[0].equals(hostname)) && (sa[1].equals("*") || sa[1].equals(port)) && (sa[2].equals("*") || sa[2].equals(database)) && (sa[3].equals("*") || sa[3].equals(username))) {
            return sa[4];
        }
        return null;
    }

    private boolean parseUrl(String url) {
        String[] r = url.split("/");
        this._hostname = "localhost";
        this._port = "5432";
        if (r.length == 1) {
            String[] r1 = r[0].split(":");
            this._database = r1[r1.length - 1];
        } else if (r.length == 4) {
            this._database = r[r.length - 1];
            String[] r1 = r[2].split(":");
            this._hostname = r1[0];
            if (r1.length == 2) {
                this._port = r1[1];
            } else if (r1.length > 2) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String getPgpass(String hostname, String port, String database, String username) {
        block9: {
            Process p1 = Runtime.getRuntime().exec("stat -c '%a' " + this._pwdfile);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p1.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p1.getErrorStream()));
            PrintWriter stdOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter(p1.getOutputStream())));
            String reply = stdInput.readLine();
            try {
                p1.waitFor();
            }
            catch (InterruptedException x) {
                System.out.println("stat for '" + this._pwdfile + "' was interrupted");
                stdInput.close();
                stdError.close();
                stdOutput.close();
                return null;
            }
            stdInput.close();
            stdError.close();
            stdOutput.close();
            if (reply == null) {
                System.out.println("Cannot stat '" + this._pwdfile + "'");
                return null;
            }
            if (reply.equals("'600'")) break block9;
            System.out.println("Protection for '" + this._pwdfile + "' must be '600'");
            return null;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this._pwdfile));
            String r = null;
            while ((line = in.readLine()) != null && r == null) {
                r = this.process(line, hostname, port, database, username);
            }
            in.close();
            return r;
        }
        catch (IOException e) {
            try {
                System.out.println("'" + this._pwdfile + "': I/O error");
                return null;
            }
            catch (IOException ex) {
                System.out.println("Cannot stat " + this._pwdfile);
                return null;
            }
        }
    }

    public String getPgpass(String url, String username) {
        if (this.parseUrl(url)) {
            return this.getPgpass(this._hostname, this._port, this._database, username);
        }
        return null;
    }

    public String getHostname() {
        return this._hostname;
    }

    public String getPort() {
        return this._port;
    }

    public String getDatabase() {
        return this._database;
    }

    public static String getPassword(String file, String url, String user, String password) {
        if (file != null && file.trim().length() > 0) {
            Pgpass pgpass = new Pgpass(file);
            return pgpass.getPgpass(url, user);
        }
        return password;
    }
}

