/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import dmg.util.HttpException;
import java.util.ArrayList;
import java.util.List;

public class HttpByteRange {
    private long _lower;
    private long _upper;

    public HttpByteRange(long lower, long upper) {
        this._lower = lower;
        this._upper = upper;
    }

    public long getLower() {
        return this._lower;
    }

    public long getUpper() {
        return this._upper;
    }

    public long getSize() {
        return this._upper - this._lower + 1L;
    }

    public static List<HttpByteRange> parseRanges(String rangeString, long lower, long upper) throws HttpException {
        String[] splitEquals = rangeString.split("=");
        if (splitEquals.length != 2 || !"bytes".equals(splitEquals[0])) {
            throw new HttpException(400, "Invalid definition of ranges");
        }
        String[] csl = splitEquals[1].split(",");
        ArrayList<HttpByteRange> ret = new ArrayList<HttpByteRange>(csl.length);
        for (String rangeSpec : csl) {
            try {
                rangeSpec = rangeSpec.trim();
                ret.add(HttpByteRange.parseRange(rangeSpec, lower, upper));
            }
            catch (HttpException e) {
                // empty catch block
            }
        }
        if (ret.size() == 0) {
            throw new HttpException(416, "Invalid (empty) list of valid ranges");
        }
        return ret;
    }

    private static HttpByteRange parseRange(String rangeSpec, long lower, long upper) throws HttpException {
        HttpByteRange ret;
        if (rangeSpec.isEmpty()) {
            throw new HttpException(400, "Invalid (empty) range");
        }
        if (Character.isDigit(rangeSpec.charAt(0))) {
            ret = HttpByteRange.parseRangeSpec(rangeSpec, lower, upper);
        } else if (rangeSpec.charAt(0) == '-') {
            ret = HttpByteRange.parseSuffixRangeSpec(rangeSpec, lower, upper);
        } else {
            throw new HttpException(400, "Invalid range");
        }
        return ret;
    }

    private static HttpByteRange parseRangeSpec(String rangeSpec, long lower, long upper) throws HttpException {
        HttpByteRange ret;
        String[] bounds = rangeSpec.split("-");
        if (bounds.length > 2) {
            throw new HttpException(400, "Invalid number of range components");
        }
        try {
            long upperV;
            long lowerV = Long.valueOf(bounds[0]);
            long l = upperV = bounds.length == 1 ? upper : Math.min(upper, Long.valueOf(bounds[1]));
            if (lowerV < lower || lowerV > upperV) {
                throw new HttpException(416, "Invalid range bounds");
            }
            ret = new HttpByteRange(lowerV, upperV);
        }
        catch (NumberFormatException e) {
            throw new HttpException(400, "Invalid numeric value");
        }
        return ret;
    }

    private static HttpByteRange parseSuffixRangeSpec(String rangeSpec, long lower, long upper) throws HttpException {
        HttpByteRange ret;
        String bound = rangeSpec.substring(1);
        try {
            long suffix = Long.valueOf(bound) - 1L;
            if (suffix < 0L) {
                throw new HttpException(400, "Invalid suffix range");
            }
            long lowerV = Math.max(upper - suffix, lower);
            ret = new HttpByteRange(lowerV, upper);
        }
        catch (NumberFormatException e) {
            throw new HttpException(400, "Invalid numeric value");
        }
        return ret;
    }
}

