/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import dmg.util.Args;
import dmg.util.CollectionFactory;
import dmg.util.Formats;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellSetupProvider;

public class HsmSet
implements CellCommandListener,
CellSetupProvider {
    private final Map<String, HsmInfo> _hsm = CollectionFactory.newHashMap();
    public static final String hh_hsm_set = "<hsmType> [<hsmInstance>] [-<key>=<value>] ... ";
    public static final String hh_hsm_unset = "<hsmInstance> [-<key>] ... ";
    public static final String hh_hsm_ls = "[<hsmInstance>] ...";
    public static final String hh_hsm_remove = "<hsmName>";

    public Set<String> getHsmInstances() {
        return this._hsm.keySet();
    }

    public HsmInfo getHsmInfoByName(String instance) {
        return this._hsm.get(instance);
    }

    public List<HsmInfo> getHsmInfoByType(String type) {
        ArrayList<HsmInfo> result = new ArrayList<HsmInfo>(this._hsm.size());
        for (HsmInfo hsm : this._hsm.values()) {
            if (!hsm.getType().equals(type)) continue;
            result.add(hsm);
        }
        return result;
    }

    public void removeInfo(String instance) {
        this._hsm.remove(instance);
    }

    public HsmInfo createInfo(String instance, String type) {
        HsmInfo info = this._hsm.get(instance);
        if (info == null) {
            info = new HsmInfo(instance, type);
            this._hsm.put(instance, info);
        }
        return info;
    }

    private void _scanOptions(HsmInfo info, Args args) {
        for (Map.Entry e : args.options().entries()) {
            String optName = (String)e.getKey();
            String optValue = (String)e.getValue();
            info.setAttribute(optName, optValue == null ? "" : optValue);
        }
    }

    private void _scanOptionsUnset(HsmInfo info, Args args) {
        for (String optName : args.options().keySet()) {
            info.unsetAttribute(optName);
        }
    }

    public String ac_hsm_set_$_1_2(Args args) {
        String type = args.argv(0);
        String instance = args.argc() == 1 ? type : args.argv(1);
        HsmInfo info = this.createInfo(instance, type);
        this._scanOptions(info, args);
        return "";
    }

    public String ac_hsm_unset_$_1(Args args) {
        String instance = args.argv(0);
        HsmInfo info = this.getHsmInfoByName(instance);
        if (info == null) {
            throw new IllegalArgumentException("Hsm not found : " + instance);
        }
        this._scanOptionsUnset(info, args);
        return "";
    }

    public String ac_hsm_ls_$_0_99(Args args) {
        StringBuilder sb = new StringBuilder();
        if (args.argc() > 0) {
            for (int i = 0; i < args.argc(); ++i) {
                this._printInfos(sb, args.argv(i));
            }
        } else {
            for (String name : this._hsm.keySet()) {
                this._printInfos(sb, name);
            }
        }
        return sb.toString();
    }

    public String ac_hsm_remove_$_1(Args args) {
        this.removeInfo(args.argv(0));
        return "";
    }

    @Override
    public void printSetup(PrintWriter pw) {
        for (HsmInfo info : this._hsm.values()) {
            for (Map.Entry<String, String> entry : info.attributes()) {
                pw.print("hsm set ");
                pw.print(info.getType());
                pw.print(" ");
                pw.print(info.getInstance());
                pw.print(" -");
                pw.print(entry.getKey());
                pw.print("=");
                pw.println(entry.getValue() == null ? "-" : entry.getValue());
            }
        }
    }

    @Override
    public void beforeSetup() {
    }

    @Override
    public void afterSetup() {
    }

    private void _printInfos(StringBuilder sb, String instance) {
        assert (instance != null);
        HsmInfo info = this.getHsmInfoByName(instance);
        if (info == null) {
            sb.append(instance).append(" not found\n");
        } else {
            sb.append(instance).append("(").append(info.getType()).append(")\n");
            for (Map.Entry<String, String> entry : info.attributes()) {
                String attrName = entry.getKey();
                String attrValue = entry.getValue();
                sb.append("   ").append(Formats.field((String)attrName, (int)20, (int)2)).append(attrValue == null ? "<set>" : attrValue).append("\n");
            }
        }
    }

    public class HsmInfo {
        private final String _type;
        private final String _instance;
        private final Map<String, String> _attr = new HashMap<String, String>();

        public HsmInfo(String instance, String type) {
            this._instance = instance;
            this._type = type.toLowerCase();
        }

        public String getInstance() {
            return this._instance;
        }

        public String getType() {
            return this._type;
        }

        public String getAttribute(String attribute) {
            return this._attr.get(attribute);
        }

        public void unsetAttribute(String attribute) {
            this._attr.remove(attribute);
        }

        public void setAttribute(String attribute, String value) {
            this._attr.put(attribute, value);
        }

        public Set<Map.Entry<String, String>> attributes() {
            return this._attr.entrySet();
        }
    }
}

