/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.EnstoreLocationExtractor;
import diskCacheV111.util.HpssLocationExtractor;
import diskCacheV111.util.HsmLocation;
import diskCacheV111.util.OsmLocationExtractor;
import java.net.URI;

public class HsmLocationExtractorFactory {
    private HsmLocationExtractorFactory() {
    }

    public static HsmLocation extractorOf(URI location) throws IllegalArgumentException {
        HsmLocation extractor;
        String hsmType;
        HsmLocationExtractorFactory.validate(location);
        switch (hsmType = location.getScheme()) {
            case "osm": {
                extractor = new OsmLocationExtractor(location);
                break;
            }
            case "enstore": {
                extractor = new EnstoreLocationExtractor(location);
                break;
            }
            case "hpss": {
                extractor = new HpssLocationExtractor(location);
                break;
            }
            default: {
                throw new IllegalArgumentException("hsmType " + hsmType + " not supported. FIXME: make it dynamic");
            }
        }
        return extractor;
    }

    public static void validate(URI location) throws IllegalArgumentException {
        if (location.getScheme() == null) {
            throw new IllegalArgumentException("hsm type not defined in " + location);
        }
        if (location.getAuthority() == null) {
            throw new IllegalArgumentException("hsm instance id not defined in " + location);
        }
    }
}

