/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;

public class HTMLWriter
extends PrintWriter {
    protected int _row;
    protected final Map<String, Object> _context;
    protected final Writer _writer;

    public HTMLWriter(OutputStream out, Map<String, Object> context) {
        super(out);
        this._context = context;
        this._writer = null;
    }

    public HTMLWriter(Writer writer, Map<String, Object> context) {
        super(writer);
        this._context = context;
        this._writer = writer;
    }

    public void addHeader(String css, String title) {
        this.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        this.println("<html>");
        this.println("<head>");
        this.println("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>");
        this.println("<link type='text/css' rel='stylesheet' href='/styles/common.css'>");
        this.println("<link type='text/css' rel='stylesheet' href='" + css + "'>");
        this.println("<title>" + title + "</title>");
        this.println("<script type='text/javascript' src='/scripts/sorting/common.js'></script>");
        this.println("<script type='text/javascript' src='/scripts/sorting/css.js'></script>");
        this.println("<script type='text/javascript' src='/scripts/sorting/standardista-table-sorting.js'></script>");
        this.println("</head>");
        this.println("<body>");
        this.println("<div id='header'>");
        this.println("<div id='bird_small'>");
        this.println("<a href='/'><img src='/images/eagleredtrans.gif'></a>");
        this.println("<br/>Birds Home</div>");
        this.println("<div id='bird_large'><img src='/images/eagle-grey.gif'></div>");
        this.println("</div>");
        this.println("<div id='main'>");
        this.println("<h1>" + title + "</h1>");
    }

    public void addFooter(String creator) {
        this.println("</div>");
        this.println("<div id=\"footer\">");
        this.println("<hr/>");
        this.printf("<address>%s at %s</address>\n", creator, new Date());
        this.println("</div>");
        this.println("</body></html>");
        this.close();
    }

    public void beginTable(String c, String ... columns) {
        this._row = 0;
        if (c != null) {
            this.printf("<table class='%s'>\n", c);
        } else {
            this.println("<table>");
        }
        if (columns.length > 0) {
            this.beginTHead();
            for (int i = 0; i < columns.length; i += 2) {
                this.th(columns[i], columns[i + 1]);
            }
            this.endTHead();
        }
    }

    public void endTable() {
        if (this._row > 0) {
            this.println("</tbody>");
        }
        this.println("</table>");
    }

    public void beginRow(String ... c) {
        if (this._row == 0) {
            this.println("<tbody>");
        }
        if (c.length == 0) {
            this.println("<tr>");
        } else {
            String s = c[this._row % c.length];
            if (s != null) {
                this.printf("<tr class='%s'>\n", s);
            } else {
                this.println("<tr>");
            }
        }
    }

    public void endRow() {
        this.endRow(true);
    }

    public void endRow(boolean increment) {
        this.println("</tr>");
        if (increment) {
            ++this._row;
        }
    }

    public void beginTHead() {
        this.println("<thead>");
        this.println("<tr>");
    }

    public void endTHead() {
        this.println("</tr>");
        this.println("</thead>");
    }

    public void td(String c, Object ... content) {
        this.td(1, 1, c, content);
    }

    public void td(int colspan, String c, Object ... content) {
        this.td(1, colspan, c, content);
    }

    public void td(int rowspan, int colspan, String c, Object ... content) {
        this.print("<td");
        if (c != null) {
            this.printf(" class=\"%s\"", c);
        }
        if (rowspan > 1) {
            this.printf(" rowspan=\"%d\"", rowspan);
        }
        if (colspan > 1) {
            this.printf(" colspan=\"%d\"", colspan);
        }
        this.print(">");
        for (Object o : content) {
            this.print(o);
        }
        this.println("</td>");
    }

    public void th(String c, Object ... content) {
        this.th(1, 1, c, content);
    }

    public void th(int colspan, String c, Object ... content) {
        this.th(1, colspan, c, content);
    }

    public void th(int rowspan, int colspan, String c, Object ... content) {
        this.print("<th");
        if (c != null) {
            this.printf(" class=\"%s\"", c);
        }
        if (rowspan > 1) {
            this.printf(" rowspan=\"%d\"", rowspan);
        }
        if (colspan > 1) {
            this.printf(" colspan=\"%d\"", colspan);
        }
        this.print(">");
        for (Object o : content) {
            this.print(o);
        }
        this.println("</th>");
    }
}

