/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.ThreadManager;
import dmg.cells.nucleus.CDC;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class FutureTimedTask<V>
extends FutureTask<V>
implements ThreadManager.TimedFuture<V> {
    private Callable<V> callable;
    private Runnable runnable;
    private Future<V> timer;
    private long createtime;
    private CDC cdc;

    public FutureTimedTask(Callable<V> callable, long createtime) {
        super(callable);
        this.callable = callable;
        this.createtime = createtime;
        this.cdc = new CDC();
    }

    public FutureTimedTask(Runnable runnable, V result, long createtime) {
        super(runnable, result);
        this.runnable = runnable;
        this.createtime = createtime;
        this.cdc = new CDC();
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    public void setTimer(Future<V> timer) {
        this.timer = timer;
    }

    public Future<V> getTimer() {
        return this.timer;
    }

    @Override
    public void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel(true);
        }
    }

    @Override
    public long getCreateTime() {
        return this.createtime;
    }

    @Override
    public void abbreviateTask(boolean abbreviate) {
        if (this.callable instanceof ThreadManager.Skippable) {
            ((ThreadManager.Skippable)((Object)this.callable)).setSkipProcessing(abbreviate);
        }
        if (this.runnable instanceof ThreadManager.Skippable) {
            ((ThreadManager.Skippable)((Object)this.runnable)).setSkipProcessing(abbreviate);
        }
    }

    @Override
    public void run() {
        try (CDC ignored = this.cdc.restore();){
            super.run();
        }
    }

    @Override
    protected boolean runAndReset() {
        try (CDC ignored = this.cdc.restore();){
            boolean bl = super.runAndReset();
            return bl;
        }
    }
}

