/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.vehicles.FileAttributes;

public class FileMetaData
implements Serializable {
    private static final String DATE_FORMAT = "MM.dd-HH:mm:ss";
    private int _uid = -1;
    private boolean _isUidSet;
    private int _gid = -1;
    private boolean _isGidSet;
    private long _size;
    private boolean _isSizeSet;
    private long _created;
    private long _lastAccessed;
    private boolean _isATimeSet;
    private long _lastModified;
    private boolean _isMTimeSet;
    private boolean _isRegular = true;
    private boolean _isDirectory;
    private boolean _isLink;
    private Permissions _user = new Permissions();
    private Permissions _group = new Permissions();
    private Permissions _world = new Permissions();
    private boolean _isUserPermissionSet;
    private boolean _isGroupPermissionSet;
    private boolean _isWorldPermissionSet;
    private static final long serialVersionUID = -6379734483795645452L;

    public FileMetaData() {
    }

    public FileMetaData(int uid, int gid, int permissions) {
        this(false, uid, gid, permissions);
    }

    public FileMetaData(boolean isDirectory, int uid, int gid, int permission) {
        this._uid = uid;
        this._gid = gid;
        this._isUidSet = true;
        this._isGidSet = true;
        this.setMode(permission);
        this.setFileType(!isDirectory, isDirectory, false);
    }

    public FileMetaData(FileAttributes attributes) {
        for (FileAttribute attribute : attributes.getDefinedAttributes()) {
            block0 : switch (attribute) {
                case OWNER: {
                    this.setUid(attributes.getOwner());
                    break;
                }
                case OWNER_GROUP: {
                    this.setGid(attributes.getGroup());
                    break;
                }
                case MODE: {
                    this.setMode(attributes.getMode());
                    break;
                }
                case TYPE: {
                    switch (attributes.getFileType()) {
                        case DIR: {
                            this.setFileType(false, true, false);
                            break block0;
                        }
                        case REGULAR: {
                            this.setFileType(true, false, false);
                            break block0;
                        }
                        case LINK: {
                            this.setFileType(false, false, true);
                            break block0;
                        }
                        case SPECIAL: {
                            this.setFileType(false, false, false);
                        }
                    }
                    break;
                }
                case SIZE: {
                    this.setSize(attributes.getSize());
                    break;
                }
                case CREATION_TIME: {
                    this._created = attributes.getCreationTime();
                    break;
                }
                case ACCESS_TIME: {
                    this.setLastAccessedTime(attributes.getAccessTime());
                    break;
                }
                case MODIFICATION_TIME: {
                    this.setLastModifiedTime(attributes.getModificationTime());
                }
            }
        }
    }

    public void setFileType(boolean isRegular, boolean isDirectory, boolean isLink) throws IllegalArgumentException {
        if (isRegular && isDirectory) {
            throw new IllegalArgumentException("can't be file and directory at the same time");
        }
        if (isRegular && isLink) {
            throw new IllegalArgumentException("can't be file and link at the same time");
        }
        if (isLink && isDirectory) {
            throw new IllegalArgumentException("can't be link and directory at the same time");
        }
        if (isRegular && isDirectory) {
            throw new IllegalArgumentException("can't be file and directory at the same time");
        }
        if (!(isRegular || isDirectory || isLink)) {
            throw new IllegalArgumentException("have to be a file or a directory  or a link");
        }
        this._isRegular = isRegular;
        this._isDirectory = isDirectory;
        this._isLink = isLink;
    }

    public long getFileSize() {
        return this._size;
    }

    public void setSize(long size) {
        this._size = size;
        this._isSizeSet = true;
    }

    public boolean isSizeSet() {
        return this._isSizeSet;
    }

    public long getCreationTime() {
        return this._created;
    }

    public long getLastModifiedTime() {
        return this._lastModified;
    }

    public long getLastAccessedTime() {
        return this._lastAccessed;
    }

    public void setTimes(long accessed, long modified, long created) {
        this._created = created;
        this.setLastAccessedTime(accessed);
        this.setLastModifiedTime(modified);
    }

    public void setLastAccessedTime(long newTime) {
        this._lastAccessed = newTime;
        this._isATimeSet = true;
    }

    public boolean isATimeSet() {
        return this._isATimeSet;
    }

    public void setLastModifiedTime(long newTime) {
        this._lastModified = newTime;
        this._isMTimeSet = true;
    }

    public boolean isMTimeSet() {
        return this._isMTimeSet;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public boolean isSymbolicLink() {
        return this._isLink;
    }

    public boolean isRegularFile() {
        return this._isRegular;
    }

    public FileType getFileType() {
        if (this.isSymbolicLink()) {
            return FileType.LINK;
        }
        if (this.isDirectory()) {
            return FileType.DIR;
        }
        if (this.isRegularFile()) {
            return FileType.REGULAR;
        }
        return FileType.SPECIAL;
    }

    public void setMode(int mode) {
        this.setUserPermissions(new Permissions(mode >> 6 & 7));
        this.setGroupPermissions(new Permissions(mode >> 3 & 7));
        this.setWorldPermissions(new Permissions(mode & 7));
    }

    public int getMode() {
        return this._user._perm << 6 | this._group._perm << 3 | this._world._perm;
    }

    public Permissions getUserPermissions() {
        return this._user;
    }

    private void setUserPermissions(Permissions userPermissions) {
        this._user = userPermissions;
        this._isUserPermissionSet = true;
    }

    public boolean isUserPermissionsSet() {
        return this._isUserPermissionSet;
    }

    public Permissions getGroupPermissions() {
        return this._group;
    }

    private void setGroupPermissions(Permissions groupPermissions) {
        this._group = groupPermissions;
        this._isGroupPermissionSet = true;
    }

    public boolean isGroupPermissionsSet() {
        return this._isGroupPermissionSet;
    }

    public Permissions getWorldPermissions() {
        return this._world;
    }

    private void setWorldPermissions(Permissions worldPermissions) {
        this._world = worldPermissions;
        this._isWorldPermissionSet = true;
    }

    public boolean isWorldPermissionsSet() {
        return this._isWorldPermissionSet;
    }

    public int getUid() {
        return this._uid;
    }

    public void setUid(int newUid) {
        this._uid = newUid;
        this._isUidSet = true;
    }

    public boolean isUidSet() {
        return this._isUidSet;
    }

    public int getGid() {
        return this._gid;
    }

    public void setGid(int newGid) {
        this._gid = newGid;
        this._isGidSet = true;
    }

    public boolean isGidSet() {
        return this._isGidSet;
    }

    public String getPermissionString() {
        return (this._isDirectory ? "d" : (this._isLink ? "l" : (this._isRegular ? "-" : "x"))) + this._user + this._group + this._world;
    }

    public boolean equalsPermissions(FileMetaData other) {
        return other != null && this.getGroupPermissions().equals(other.getGroupPermissions()) && this.getUserPermissions().equals(other.getUserPermissions()) && this.getWorldPermissions().equals(other.getWorldPermissions());
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        return "[" + (this._isDirectory ? "d" : (this._isLink ? "l" : (this._isRegular ? "-" : "x"))) + this._user + this._group + this._world + ";" + this._uid + ";" + this._gid + "]" + "[c=" + formatter.format(new Date(this._created)) + ";m=" + formatter.format(new Date(this._lastModified)) + ";a=" + formatter.format(new Date(this._lastAccessed)) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FileMetaData)) {
            return false;
        }
        FileMetaData other = (FileMetaData)obj;
        return other._gid == this._gid && other._uid == this._uid && other._isDirectory == this._isDirectory && other._isLink == this._isLink && other._isRegular == this._isRegular && (other._size == this._size || this._isDirectory) && other._user.equals(this._user) && other._group.equals(this._group) && other._world.equals(this._world) && other._created == this._created && other._lastAccessed == this._lastAccessed && other._lastModified == this._lastModified;
    }

    public int hashCode() {
        return 17;
    }

    public FileAttributes toFileAttributes() {
        FileAttributes attributes = new FileAttributes();
        if (this._isUidSet) {
            attributes.setOwner(this._uid);
        }
        if (this._isGidSet) {
            attributes.setGroup(this._gid);
        }
        if (this._isSizeSet) {
            attributes.setSize(this._size);
        }
        if (this._created > 0L) {
            attributes.setCreationTime(this._created);
        }
        if (this._isATimeSet) {
            attributes.setAccessTime(this._lastAccessed);
        }
        if (this._isMTimeSet) {
            attributes.setModificationTime(this._lastModified);
        }
        if (this._isUserPermissionSet || this._isGroupPermissionSet || this._isWorldPermissionSet) {
            attributes.setMode(this.getMode());
        }
        attributes.setFileType(this.getFileType());
        return attributes;
    }

    public static Set<FileAttribute> getKnownFileAttributes() {
        return EnumSet.of(FileAttribute.OWNER, new FileAttribute[]{FileAttribute.OWNER_GROUP, FileAttribute.MODE, FileAttribute.TYPE, FileAttribute.SIZE, FileAttribute.CREATION_TIME, FileAttribute.ACCESS_TIME, FileAttribute.MODIFICATION_TIME});
    }

    public static class Permissions
    implements Serializable {
        private final boolean _canRead;
        private final boolean _canWrite;
        private final boolean _canExecute;
        private final int _perm;
        private static final long serialVersionUID = -1340210599513069884L;

        public Permissions() {
            this(0);
        }

        public Permissions(int perm) {
            this._perm = perm;
            this._canRead = (perm & 4) > 0;
            this._canWrite = (perm & 2) > 0;
            this._canExecute = (perm & 1) > 0;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Permissions)) {
                return false;
            }
            return ((Permissions)obj)._perm == this._perm;
        }

        public int hashCode() {
            return this._perm;
        }

        public boolean canRead() {
            return this._canRead;
        }

        public boolean canWrite() {
            return this._canWrite;
        }

        public boolean canExecute() {
            return this._canExecute;
        }

        public boolean canLookup() {
            return this.canExecute();
        }

        public String toString() {
            return (this._canRead ? "r" : "-") + (this._canWrite ? "w" : "-") + (this._canExecute ? "x" : "-");
        }
    }
}

