/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.net.URI;
import java.net.URISyntaxException;

public class DCapUrl {
    private static final String REQUIRED_URI_SCHEME_SUFFIX = "dcap";
    private final URI _uri;

    public DCapUrl(String dCapUrl) throws IllegalArgumentException {
        try {
            this._uri = new URI(dCapUrl);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException("Invalid dCap URI: " + ue);
        }
        if (!this._uri.isAbsolute()) {
            throw new IllegalArgumentException("Missing schema in dCap URI: " + this._uri);
        }
        String scheme = this._uri.getScheme();
        if (!scheme.toLowerCase().endsWith(REQUIRED_URI_SCHEME_SUFFIX)) {
            throw new IllegalArgumentException("Invalid URI scheme '+ scheme+': " + this._uri);
        }
        if (this._uri.isOpaque()) {
            throw new IllegalArgumentException("dCap URIs are not opaque: " + this._uri);
        }
        if (this._uri.getAuthority() == null) {
            throw new IllegalArgumentException("Authority not present in dCap URI: " + this._uri);
        }
        String path = this._uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Missing path in dCap url: " + this._uri);
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Non-absolute path in dCap url: " + this._uri);
        }
    }

    public String getFilePart() {
        return this._uri.getPath();
    }

    public String getProtocol() {
        return this._uri.getScheme();
    }
}

