/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.IoPackage;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.dcache.util.JdbcConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager {
    private static DBManager _instance;
    private JdbcConnectionPool connectionPool;
    private static Logger _logger;

    private DBManager() {
    }

    public synchronized void initConnectionPool(String url, String driver, String user, String password) throws SQLException {
        this.connectionPool = JdbcConnectionPool.getPool(url, driver, user, password != null ? password : "srm");
    }

    public static final synchronized DBManager getInstance() {
        if (_instance == null) {
            _instance = new DBManager();
        }
        return _instance;
    }

    public JdbcConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public <T> Set<T> select(IoPackage<T> pkg, String query) throws SQLException {
        Connection connection = null;
        try {
            Set<T> set;
            connection = this.connectionPool.getConnection();
            Set<T> set2 = set = pkg.select(connection, query);
            return set2;
        }
        catch (SQLException e) {
            if (connection != null) {
                this.connectionPool.returnFailedConnection(connection);
                connection = null;
            }
            throw e;
        }
        finally {
            if (connection != null) {
                this.connectionPool.returnConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public <T> T selectForUpdate(Connection connection, IoPackage<T> pkg, String query, Object ... args) throws SQLException {
        _logger.debug("executing selectForUpdate on {} with args={}", (Object)query, (Object)args);
        PreparedStatement stmt = null;
        stmt = connection.prepareStatement(query);
        for (int i = 0; i < args.length; ++i) {
            stmt.setObject(i + 1, args[i]);
        }
        T t = pkg.selectForUpdate(connection, stmt);
        return t;
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException e1) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Set<T> selectPrepared(IoPackage<T> pkg, String query, Object ... args) throws SQLException {
        _logger.debug("executing statement: {}", (Object)query);
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.connectionPool.getConnection();
            stmt = connection.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            Set<T> set = pkg.selectPrepared(connection, stmt);
            stmt.close();
            this.connectionPool.returnConnection(connection);
            connection = null;
            stmt = null;
            Set<T> set2 = set;
            return set2;
        }
        finally {
            if (connection != null) {
                if (stmt != null) {
                    try {
                        stmt.close();
                        stmt = null;
                    }
                    catch (SQLException e1) {}
                }
                this.connectionPool.returnFailedConnection(connection);
                connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object selectPrepared(int columnIndex, String query, Object ... args) throws SQLException {
        Connection connection = null;
        Object obj = null;
        PreparedStatement stmt = null;
        try {
            connection = this.connectionPool.getConnection();
            stmt = connection.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            ResultSet set = stmt.executeQuery();
            if (set.next()) {
                obj = set.getObject(columnIndex);
            }
            stmt.close();
            this.connectionPool.returnConnection(connection);
            connection = null;
            stmt = null;
            Object object = obj;
            return object;
        }
        finally {
            if (connection != null) {
                if (stmt != null) {
                    try {
                        stmt.close();
                        stmt = null;
                    }
                    catch (SQLException e1) {}
                }
                this.connectionPool.returnFailedConnection(connection);
                connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTable(String table) throws SQLException {
        boolean hasTable = false;
        Connection connection = this.connectionPool.getConnection();
        try {
            hasTable = this.hasTable(connection, table);
            this.connectionPool.returnConnection(connection);
            connection = null;
        }
        finally {
            if (connection != null) {
                this.connectionPool.returnFailedConnection(connection);
            }
        }
        return hasTable;
    }

    private boolean hasTable(Connection connection, String table) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        boolean hasTable = false;
        try (ResultSet set = metadata.getTables(null, null, table, null);){
            hasTable = set.next();
        }
        return hasTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(String name, String ... statements) throws SQLException {
        Connection connection = null;
        ResultSet set = null;
        try {
            connection = this.connectionPool.getConnection();
            if (this.hasTable(connection, name)) {
                throw new SQLException("Table \"" + name + "\" already exists");
            }
            for (String statement : statements) {
                Statement s = null;
                try {
                    s = connection.createStatement();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Executing  " + statement);
                    }
                    s.executeUpdate(statement);
                    connection.commit();
                    s.close();
                    s = null;
                }
                catch (SQLException e) {
                    try {
                        connection.rollback();
                        if (s != null) {
                            s.close();
                            s = null;
                        }
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    if (!_logger.isDebugEnabled()) continue;
                    _logger.debug("Failed: " + e.getMessage());
                }
            }
        }
        finally {
            if (connection != null) {
                if (set != null) {
                    try {
                        set.close();
                        set = null;
                    }
                    catch (SQLException e1) {}
                }
                this.connectionPool.returnConnection(connection);
                connection = null;
            }
        }
    }

    public void createIndexes(String name, String ... columns) throws SQLException {
        Connection connection = null;
        ResultSet set = null;
        try {
            connection = this.connectionPool.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            set = md.getIndexInfo(null, null, name, false, false);
            HashSet<String> listOfColumnsToBeIndexed = new HashSet<String>(Arrays.asList(columns));
            while (set.next()) {
                String s = set.getString("column_name").toLowerCase();
                if (!listOfColumnsToBeIndexed.contains(s)) continue;
                listOfColumnsToBeIndexed.remove(s);
            }
            for (String column : listOfColumnsToBeIndexed) {
                StringBuilder indexName = new StringBuilder();
                indexName.append(name.toLowerCase()).append("_").append(column.replaceAll("\\W", "_")).append("_idx");
                StringBuilder createIndexStatementText = new StringBuilder();
                createIndexStatementText.append("CREATE INDEX ").append(indexName.toString()).append(" ON ").append(name).append(" (").append(column).append(")");
                Statement s = null;
                try {
                    s = connection.createStatement();
                    int result = s.executeUpdate(createIndexStatementText.toString());
                    connection.commit();
                    s.close();
                    s = null;
                }
                catch (SQLException e) {
                    try {
                        connection.rollback();
                        if (s == null) continue;
                        s.close();
                        s = null;
                    }
                    catch (SQLException e1) {}
                }
            }
        }
        catch (SQLException e) {
            if (connection != null) {
                if (set != null) {
                    try {
                        set.close();
                        set = null;
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                }
                this.connectionPool.returnFailedConnection(connection);
                connection = null;
            }
            throw e;
        }
        finally {
            if (connection != null) {
                if (set != null) {
                    try {
                        set.close();
                        set = null;
                    }
                    catch (SQLException e1) {}
                }
                this.connectionPool.returnConnection(connection);
                connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String query, Object ... args) throws SQLException {
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.connectionPool.getConnection();
            stmt = connection.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            int result = stmt.executeUpdate();
            connection.commit();
            stmt.close();
            this.connectionPool.returnConnection(connection);
            connection = null;
            stmt = null;
            int n = result;
            return n;
        }
        finally {
            if (connection != null) {
                try {
                    connection.rollback();
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (SQLException e1) {}
                this.connectionPool.returnConnection(connection);
                connection = null;
            }
        }
    }

    public int delete(String query, Object ... args) throws SQLException {
        return this.update(query, args);
    }

    public int insert(String query, Object ... args) throws SQLException {
        return this.update(query, args);
    }

    public void batchUpdates(String ... statements) throws SQLException {
        for (String statement : statements) {
            try {
                this.update(statement, new Object[0]);
            }
            catch (SQLException sql) {
                throw new SQLException("Statement " + statement + " failed");
            }
        }
    }

    public void batchDeletes(String ... statements) throws SQLException {
        this.batchUpdates(statements);
    }

    public void batchInserts(String ... statements) throws SQLException {
        this.batchUpdates(statements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, String query, Object ... args) throws SQLException {
        _logger.debug("executing update {}, args={}", (Object)query, (Object)args);
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException e1) {}
            }
        }
    }

    public int delete(Connection connection, String query, Object ... args) throws SQLException {
        return this.update(connection, query, args);
    }

    public int insert(Connection connection, String query, Object ... args) throws SQLException {
        return this.update(connection, query, args);
    }

    static {
        _logger = LoggerFactory.getLogger((String)"logger.org.dcache.db.sql");
    }
}

