/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.vehicles.StorageInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;

public class CheckStagePermission {
    private File _stageConfigFile;
    private long _lastTimeReadingStageConfigFile;
    private List<Pattern[]> _regexList;
    private final boolean _isEnabled;
    private final ReadWriteLock _fileReadWriteLock = new ReentrantReadWriteLock();
    private final Lock _fileReadLock = this._fileReadWriteLock.readLock();
    private final Lock _fileWriteLock = this._fileReadWriteLock.writeLock();

    public CheckStagePermission(String stageConfigurationFilePath) {
        if (stageConfigurationFilePath == null || stageConfigurationFilePath.length() == 0) {
            this._isEnabled = false;
            return;
        }
        this._stageConfigFile = new File(stageConfigurationFilePath);
        this._isEnabled = true;
    }

    public boolean canPerformStaging(Subject subject, StorageInfo storageInfo) throws PatternSyntaxException, IOException {
        if (!this._isEnabled || Subjects.isRoot((Subject)subject)) {
            return true;
        }
        try {
            String dn = Subjects.getDn((Subject)subject);
            Collection fqans = Subjects.getFqans((Subject)subject);
            String storageClass = storageInfo.getStorageClass();
            String hsm = storageInfo.getHsm();
            String storeUnit = "";
            if (storageClass != null && hsm != null) {
                storeUnit = storageClass + "@" + hsm;
            }
            if (dn == null) {
                dn = "";
            }
            if (fqans.isEmpty()) {
                return this.canPerformStaging(dn, "", storeUnit);
            }
            for (String fqan : fqans) {
                if (!this.canPerformStaging(dn, fqan, storeUnit)) continue;
                return true;
            }
            return false;
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Subject has multiple DNs");
        }
    }

    public boolean canPerformStaging(String dn, String fqan, String storeUnit) throws PatternSyntaxException, IOException {
        if (!this._isEnabled) {
            return true;
        }
        if (!this._stageConfigFile.exists()) {
            return false;
        }
        if (this.fileNeedsRereading()) {
            this.rereadConfig();
        }
        if (fqan == null) {
            fqan = "";
        }
        return this.userMatchesPredicates(dn, fqan, storeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rereadConfig() throws PatternSyntaxException, IOException {
        block15: {
            try {
                this._fileWriteLock.lock();
                if (!this.fileNeedsRereading()) break block15;
                try (BufferedReader reader = new BufferedReader(new FileReader(this._stageConfigFile));){
                    this._regexList = this.readStageConfigFile(reader);
                    this._lastTimeReadingStageConfigFile = System.currentTimeMillis();
                }
            }
            finally {
                this._fileWriteLock.unlock();
            }
        }
    }

    boolean fileNeedsRereading() {
        long modificationTimeStageConfigFile = this._stageConfigFile.lastModified();
        return modificationTimeStageConfigFile > this._lastTimeReadingStageConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean userMatchesPredicates(String dn, String fqanStr, String storeUnit) {
        try {
            this._fileReadLock.lock();
            for (Pattern[] regexLine : this._regexList) {
                if (!regexLine[0].matcher(dn).matches()) continue;
                if (regexLine[1] == null) {
                    boolean bl = true;
                    return bl;
                }
                if (!regexLine[1].matcher(fqanStr).matches() || regexLine[2] != null && !regexLine[2].matcher(storeUnit).matches()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this._fileReadLock.unlock();
        }
        return false;
    }

    List<Pattern[]> readStageConfigFile(BufferedReader reader) throws IOException, PatternSyntaxException {
        String line;
        Pattern linePattern = Pattern.compile("\"([^\"]*)\"([ \t]+\"([^\"]*)\"([ \t]+\"([^\"]*)\")?)?");
        ArrayList<Pattern[]> regexList = new ArrayList<Pattern[]>();
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            Matcher matcherLine = linePattern.matcher(line);
            if (line.startsWith("#") || line.isEmpty() || !matcherLine.matches()) continue;
            Pattern[] arrayPattern = new Pattern[3];
            String matchDN = matcherLine.group(1);
            String matchFQAN = matcherLine.group(3);
            String matchStoreUnit = matcherLine.group(5);
            if (matchFQAN != null) {
                if (matchStoreUnit != null) {
                    arrayPattern[0] = Pattern.compile(matchDN);
                    arrayPattern[1] = Pattern.compile(matchFQAN);
                    arrayPattern[2] = Pattern.compile(matchStoreUnit);
                    regexList.add(arrayPattern);
                    continue;
                }
                arrayPattern[0] = Pattern.compile(matchDN);
                arrayPattern[1] = Pattern.compile(matchFQAN);
                arrayPattern[2] = null;
                regexList.add(arrayPattern);
                continue;
            }
            arrayPattern[0] = Pattern.compile(matchDN);
            arrayPattern[1] = null;
            arrayPattern[2] = null;
            regexList.add(arrayPattern);
        }
        return regexList;
    }
}

