/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

public class CacheException
extends Exception {
    private static final long serialVersionUID = 3219663683702355240L;
    public static final int POOL_DISABLED = 104;
    public static final int ERROR_IO_DISK = 204;
    public static final int FILE_IN_CACHE = 210;
    public static final int PANIC = 10000;
    public static final int FILE_NOT_FOUND = 10001;
    public static final int FILE_PRECIOUS = 10002;
    public static final int FILESIZE_UNKNOWN = 10003;
    public static final int FILE_CORRUPTED = 10004;
    public static final int FILE_NOT_STORED = 10005;
    public static final int TIMEOUT = 10006;
    public static final int FILE_NOT_IN_REPOSITORY = 10007;
    public static final int FILE_EXISTS = 10008;
    public static final int NOT_DIR = 10010;
    public static final int UNEXPECTED_SYSTEM_EXCEPTION = 10011;
    public static final int ATTRIBUTE_FORMAT_ERROR = 10012;
    public static final int HSM_DELAY_ERROR = 10013;
    public static final int NOT_FILE = 10014;
    public static final int INVALID_ARGS = 10015;
    public static final int NOT_IN_TRASH = 10016;
    public static final int RESOURCE = 10017;
    public static final int PERMISSION_DENIED = 10018;
    public static final int FILE_NOT_ONLINE = 10019;
    public static final int LOCKED = 10020;
    public static final int OUT_OF_DATE = 10021;
    public static final int FILE_IS_NEW = 10022;
    public static final int DEFAULT_ERROR_CODE = 666;
    private final int _rc;
    @Deprecated
    private final String _message = this.getMessage();

    private static String formatMessage(String message) {
        if (message == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == '\n') {
                if (i == message.length() - 1) continue;
                sb.append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public CacheException(String message) {
        this(message, null);
    }

    public CacheException(String message, Throwable cause) {
        this(666, message, cause);
    }

    public CacheException(int rc, String message) {
        this(rc, message, null);
    }

    public CacheException(int rc, String message, Throwable cause) {
        super(CacheException.formatMessage(message), cause);
        this._rc = rc;
    }

    public int getRc() {
        return this._rc;
    }

    @Override
    public String toString() {
        return "CacheException(rc=" + this._rc + ";msg=" + this.getMessage() + ")";
    }
}

