/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AuthorizedKeyParser {
    private byte[] bytes;
    private int pos;

    public PublicKey decodePublicKey(String keyLine) throws IllegalArgumentException, InvalidKeySpecException, NoSuchAlgorithmException {
        String type;
        this.bytes = null;
        this.pos = 0;
        for (String part : keyLine.split(" ")) {
            if (!part.startsWith("AAAA")) continue;
            this.bytes = Base64.decodeBase64((String)part);
            break;
        }
        if (this.bytes == null) {
            throw new IllegalArgumentException("no Base64 part to decode");
        }
        switch (type = this.decodeType()) {
            case "ssh-rsa": {
                BigInteger e = this.decodeBigInt();
                BigInteger m = this.decodeBigInt();
                RSAPublicKeySpec spec = new RSAPublicKeySpec(m, e);
                return KeyFactory.getInstance("RSA").generatePublic(spec);
            }
            case "ssh-dss": {
                BigInteger p = this.decodeBigInt();
                BigInteger q = this.decodeBigInt();
                BigInteger g = this.decodeBigInt();
                BigInteger y = this.decodeBigInt();
                DSAPublicKeySpec spec = new DSAPublicKeySpec(y, p, q, g);
                return KeyFactory.getInstance("DSA").generatePublic(spec);
            }
        }
        throw new IllegalArgumentException("unknown type " + type);
    }

    private String decodeType() {
        int len = this.decodeInt();
        String type = new String(this.bytes, this.pos, len);
        this.pos += len;
        return type;
    }

    private int decodeInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    private BigInteger decodeBigInt() {
        int len = this.decodeInt();
        byte[] bigIntBytes = new byte[len];
        System.arraycopy(this.bytes, this.pos, bigIntBytes, 0, len);
        this.pos += len;
        return new BigInteger(bigIntBytes);
    }
}

