/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.util.PnfsId;
import javax.security.auth.Subject;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.cells.ThreadManagerMessageCallback;
import org.dcache.pinmanager.PinManagerUnpinMessage;
import org.dcache.srm.UnpinCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpinCompanion
extends AbstractMessageCallback<PinManagerUnpinMessage> {
    private static final Logger _log = LoggerFactory.getLogger(UnpinCompanion.class);
    private UnpinCallbacks callbacks;
    private PnfsId pnfsId;

    private UnpinCompanion(PnfsId pnfsId, UnpinCallbacks callbacks) {
        this.pnfsId = pnfsId;
        this.callbacks = callbacks;
    }

    @Override
    public void success(PinManagerUnpinMessage message) {
        this.callbacks.Unpinned(String.valueOf(message.getPinId()));
    }

    @Override
    public void failure(int rc, Object error) {
        switch (rc) {
            case 10006: {
                _log.error(error.toString());
                this.callbacks.Timeout();
                break;
            }
            default: {
                _log.error("Unpinning failed for {} [rc={},msg={}]", new Object[]{this.pnfsId, rc, error});
                String reason = String.format("Failed to unpin file [rc=%d,msg=%s]", rc, error);
                this.callbacks.UnpinningFailed(reason);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + " " + this.pnfsId;
    }

    public static void unpinFile(Subject subject, PnfsId pnfsId, long pinId, UnpinCallbacks callbacks, CellStub pinManagerStub) {
        _log.info("UnpinCompanion.unpinFile({})", (Object)pnfsId);
        UnpinCompanion companion = new UnpinCompanion(pnfsId, callbacks);
        PinManagerUnpinMessage msg = new PinManagerUnpinMessage(pnfsId);
        msg.setPinId(pinId);
        msg.setSubject(subject);
        pinManagerStub.send(msg, PinManagerUnpinMessage.class, new ThreadManagerMessageCallback<PinManagerUnpinMessage>(companion));
    }

    public static void unpinFileBySrmRequestId(Subject subject, PnfsId pnfsId, long srmRequestId, UnpinCallbacks callbacks, CellStub pinManagerStub) {
        _log.info("UnpinCompanion.unpinFile({})", (Object)pnfsId);
        UnpinCompanion companion = new UnpinCompanion(pnfsId, callbacks);
        PinManagerUnpinMessage msg = new PinManagerUnpinMessage(pnfsId);
        msg.setRequestId(String.valueOf(srmRequestId));
        msg.setSubject(subject);
        pinManagerStub.send(msg, PinManagerUnpinMessage.class, new ThreadManagerMessageCallback<PinManagerUnpinMessage>(companion));
    }

    public static void unpinFile(Subject subject, PnfsId pnfsId, UnpinCallbacks callbacks, CellStub pinManagerStub) {
        _log.info("UnpinCompanion.unpinFile({}", (Object)pnfsId);
        UnpinCompanion companion = new UnpinCompanion(pnfsId, callbacks);
        PinManagerUnpinMessage msg = new PinManagerUnpinMessage(pnfsId);
        msg.setSubject(subject);
        pinManagerStub.send(msg, PinManagerUnpinMessage.class, new ThreadManagerMessageCallback<PinManagerUnpinMessage>(companion));
    }
}

