/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.services.space.message.CancelUse;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.TimeoutCacheException;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.cells.CellStub;
import org.dcache.srm.SrmCancelUseOfSpaceCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SrmUnmarkSpaceAsBeingUsedCompanion {
    private static final Logger _log = LoggerFactory.getLogger(SrmUnmarkSpaceAsBeingUsedCompanion.class);
    private final long spaceToken;
    private final String pnfPath;
    private final SrmCancelUseOfSpaceCallbacks callbacks;

    private SrmUnmarkSpaceAsBeingUsedCompanion(long spaceToken, String pnfPath, SrmCancelUseOfSpaceCallbacks callbacks) {
        this.spaceToken = spaceToken;
        this.pnfPath = pnfPath;
        this.callbacks = callbacks;
    }

    public String toString() {
        return this.getClass().getName() + " [token:" + this.spaceToken + " path:" + this.pnfPath + "]";
    }

    public void failure(int rc, Object error) {
        _log.error("Unmarking Space as Being Used Failed: rc=" + rc + " error:" + error);
        this.callbacks.CancelUseOfSpaceFailed("Unmarking Space as Being Used failed: rc=" + rc + " error:" + error);
    }

    public void noroute() {
        _log.error("Unmarking Space as Being Used Failed : No route to SrmSpaceManager");
        this.callbacks.CancelUseOfSpaceFailed("Unmarking Space as Being Used Failed : No Route to SrmSpaceManager");
    }

    public void success(CancelUse message) {
        _log.debug("success");
        this.callbacks.UseOfSpaceSpaceCanceled();
    }

    public void timeout() {
        _log.error("Timeout waiting for answer from SrmSpaceManager");
        this.callbacks.CancelUseOfSpaceFailed("Timeout waiting for answer from SrmSpaceManager");
    }

    public static void unmarkSpace(AuthorizationRecord user, long spaceToken, String pnfPath, SrmCancelUseOfSpaceCallbacks callbacks, CellStub spaceManagerStub) {
        _log.debug(" SrmMarkSpaceAsBeingUsedCompanion.markSpace(" + user + " for spaceToken" + spaceToken + " pnfsPath=" + pnfPath + ")");
        SrmUnmarkSpaceAsBeingUsedCompanion companion = new SrmUnmarkSpaceAsBeingUsedCompanion(spaceToken, pnfPath, callbacks);
        CancelUse cancelUse = new CancelUse(spaceToken, pnfPath, null);
        cancelUse.setReplyRequired(true);
        try {
            cancelUse = spaceManagerStub.sendAndWait(cancelUse, CancelUse.class);
            if (cancelUse.getReturnCode() != 0) {
                companion.failure(cancelUse.getReturnCode(), cancelUse.getErrorObject());
            } else {
                companion.success(cancelUse);
            }
        }
        catch (TimeoutCacheException e) {
            companion.timeout();
        }
        catch (InterruptedException e) {
            callbacks.CancelUseOfSpaceFailed("Unmark space as being used was interrupted " + companion);
        }
        catch (CacheException e) {
            if (e.getRc() != 0) {
                companion.failure(e.getRc(), e);
            }
            companion.success(null);
        }
    }
}

