/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.services.space.NoFreeSpaceException;
import diskCacheV111.services.space.SpaceException;
import diskCacheV111.services.space.message.Reserve;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import dmg.cells.nucleus.CellPath;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.cells.ThreadManagerMessageCallback;
import org.dcache.srm.SrmReserveSpaceCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SrmReserveSpaceCompanion
extends AbstractMessageCallback<Reserve> {
    private static final Logger _log = LoggerFactory.getLogger(SrmReserveSpaceCompanion.class);
    private final long sizeInBytes;
    private final long spaceReservationLifetime;
    private final String retentionPolicy;
    private final String accessLatency;
    private final String description;
    private final SrmReserveSpaceCallbacks callbacks;

    private SrmReserveSpaceCompanion(long sizeInBytes, long spaceReservationLifetime, String retentionPolicy, String accessLatency, String description, SrmReserveSpaceCallbacks callbacks) {
        this.sizeInBytes = sizeInBytes;
        this.spaceReservationLifetime = spaceReservationLifetime;
        this.retentionPolicy = retentionPolicy;
        this.accessLatency = accessLatency;
        this.description = description;
        this.callbacks = callbacks;
    }

    @Override
    public void failure(int rc, Object error) {
        _log.error("Space Reservation Failed rc:" + rc + " error:" + error);
        if (error instanceof NoFreeSpaceException) {
            NoFreeSpaceException nfse = (NoFreeSpaceException)error;
            this.callbacks.NoFreeSpace(nfse.getMessage());
            return;
        }
        if (error instanceof SpaceException) {
            SpaceException se = (SpaceException)error;
            this.callbacks.ReserveSpaceFailed(se.getMessage());
            return;
        }
        this.callbacks.ReserveSpaceFailed("Space Reservation Failed rc:" + rc + " error:" + error);
    }

    @Override
    public void noroute(CellPath path) {
        _log.error("No Route to SrmSpaceManager");
        this.callbacks.ReserveSpaceFailed("No Route to SrmSpaceManager");
    }

    @Override
    public void success(Reserve reservationResponse) {
        _log.debug("success");
        this.callbacks.SpaceReserved(Long.toString(reservationResponse.getSpaceToken()), reservationResponse.getSizeInBytes());
    }

    @Override
    public void timeout(CellPath path) {
        _log.error("Timeout waiting for answer from SrmSpaceManager");
        this.callbacks.ReserveSpaceFailed("Timeout waiting for answer from SrmSpaceManager");
    }

    public String toString() {
        return this.getClass().getName() + " [size:" + this.sizeInBytes + " " + this.accessLatency + " " + this.retentionPolicy + " lifetime:" + this.spaceReservationLifetime + "]";
    }

    public static void reserveSpace(AuthorizationRecord user, long sizeInBytes, long spaceReservationLifetime, String retentionPolicyString, String accessLatencyString, String description, SrmReserveSpaceCallbacks callbacks, CellStub spaceManagerStub) {
        _log.debug(" SrmReserveSpaceCompanion.reserveSpace(" + user + " for " + sizeInBytes + " bytes, access lat.=" + accessLatencyString + " retention pol.=" + retentionPolicyString + " lifetime=" + spaceReservationLifetime + ")");
        SrmReserveSpaceCompanion companion = new SrmReserveSpaceCompanion(sizeInBytes, spaceReservationLifetime, retentionPolicyString, accessLatencyString, description, callbacks);
        AccessLatency accessLatency = null;
        RetentionPolicy retentionPolicy = null;
        if (accessLatencyString != null) {
            try {
                accessLatency = AccessLatency.getAccessLatency((String)accessLatencyString);
            }
            catch (IllegalArgumentException iae) {
                callbacks.ReserveSpaceFailed((Exception)iae);
                return;
            }
        }
        if (retentionPolicyString != null) {
            try {
                retentionPolicy = RetentionPolicy.getRetentionPolicy((String)retentionPolicyString);
            }
            catch (IllegalArgumentException iae) {
                callbacks.ReserveSpaceFailed((Exception)iae);
                return;
            }
        }
        Reserve reserve = new Reserve(user, sizeInBytes, retentionPolicy, accessLatency, spaceReservationLifetime, description);
        spaceManagerStub.send(reserve, Reserve.class, new ThreadManagerMessageCallback<Reserve>(companion));
    }
}

